/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.math.expr;

import javax.annotation.Nullable;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.Comparators;
import org.apache.hive.druid.org.apache.druid.math.expr.BinaryEvalOpExprBase;
import org.apache.hive.druid.org.apache.druid.math.expr.BinaryOpExprBase;
import org.apache.hive.druid.org.apache.druid.math.expr.Evals;
import org.apache.hive.druid.org.apache.druid.math.expr.Expr;
import org.apache.hive.druid.org.apache.druid.math.expr.ExprEval;
import org.apache.hive.druid.org.apache.druid.math.expr.ExprType;

class BinGeqExpr
extends BinaryEvalOpExprBase {
    BinGeqExpr(String op, Expr left, Expr right) {
        super(op, left, right);
    }

    @Override
    protected BinaryOpExprBase copy(Expr left, Expr right) {
        return new BinGeqExpr(this.op, left, right);
    }

    @Override
    protected ExprEval evalString(@Nullable String left, @Nullable String right) {
        return ExprEval.of(Comparators.naturalNullsFirst().compare(left, right) >= 0, ExprType.LONG);
    }

    @Override
    protected final long evalLong(long left, long right) {
        return Evals.asLong(left >= right);
    }

    @Override
    protected final double evalDouble(double left, double right) {
        return Evals.asDouble(Double.compare(left, right) >= 0);
    }
}

