/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.math.expr;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.org.apache.druid.java.util.common.StringUtils;
import org.apache.hive.druid.org.apache.druid.math.expr.ApplyFunction;
import org.apache.hive.druid.org.apache.druid.math.expr.Expr;
import org.apache.hive.druid.org.apache.druid.math.expr.ExprEval;
import org.apache.hive.druid.org.apache.druid.math.expr.LambdaExpr;

class ApplyFunctionExpr
implements Expr {
    final ApplyFunction function;
    final String name;
    final LambdaExpr lambdaExpr;
    final ImmutableList<Expr> argsExpr;
    final Expr.BindingDetails bindingDetails;
    final Expr.BindingDetails lambdaBindingDetails;
    final ImmutableList<Expr.BindingDetails> argsBindingDetails;

    ApplyFunctionExpr(ApplyFunction function, String name, LambdaExpr expr, List<Expr> args) {
        this.function = function;
        this.name = name;
        this.argsExpr = ImmutableList.copyOf(args);
        this.lambdaExpr = expr;
        function.validateArguments(expr, args);
        ImmutableList.Builder argBindingDetailsBuilder = ImmutableList.builder();
        Expr.BindingDetails accumulator = new Expr.BindingDetails();
        for (Expr arg : this.argsExpr) {
            Expr.BindingDetails argDetails = arg.analyzeInputs();
            argBindingDetailsBuilder.add(argDetails);
            accumulator = accumulator.with(argDetails);
        }
        this.lambdaBindingDetails = this.lambdaExpr.analyzeInputs();
        this.bindingDetails = accumulator.with(this.lambdaBindingDetails).withArrayArguments(function.getArrayInputs(this.argsExpr)).withArrayInputs(true).withArrayOutput(function.hasArrayOutput(this.lambdaExpr));
        this.argsBindingDetails = argBindingDetailsBuilder.build();
    }

    public String toString() {
        return StringUtils.format("(%s %s, %s)", this.name, this.lambdaExpr, this.argsExpr);
    }

    @Override
    public ExprEval eval(Expr.ObjectBinding bindings) {
        return this.function.apply(this.lambdaExpr, this.argsExpr, bindings);
    }

    @Override
    public void visit(Expr.Visitor visitor) {
        this.lambdaExpr.visit(visitor);
        for (Expr arg : this.argsExpr) {
            arg.visit(visitor);
        }
        visitor.visit(this);
    }

    @Override
    public Expr visit(Expr.Shuttle shuttle) {
        LambdaExpr newLambda = (LambdaExpr)this.lambdaExpr.visit(shuttle);
        List<Expr> newArgs = this.argsExpr.stream().map(shuttle::visit).collect(Collectors.toList());
        return shuttle.visit(new ApplyFunctionExpr(this.function, this.name, newLambda, newArgs));
    }

    @Override
    public Expr.BindingDetails analyzeInputs() {
        return this.bindingDetails;
    }
}

