/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.java.util.common.parsers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.google.common.annotations.VisibleForTesting;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.base.Splitter;
import org.apache.hive.druid.org.apache.druid.common.config.NullHandling;
import org.apache.hive.druid.org.apache.druid.java.util.common.parsers.ParseException;
import org.joda.time.DateTimeZone;

public class ParserUtils {
    private static final String DEFAULT_COLUMN_NAME_PREFIX = "column_";
    private static final Map<String, DateTimeZone> TIMEZONE_LOOKUP = new HashMap<String, DateTimeZone>();

    public static Function<String, Object> getMultiValueFunction(String listDelimiter, Splitter listSplitter) {
        return input -> {
            if (input != null && input.contains(listDelimiter)) {
                return StreamSupport.stream(listSplitter.split((CharSequence)input).spliterator(), false).map(NullHandling::emptyToNullIfNeeded).collect(Collectors.toList());
            }
            return NullHandling.emptyToNullIfNeeded(input);
        };
    }

    public static ArrayList<String> generateFieldNames(int length) {
        ArrayList<String> names = new ArrayList<String>(length);
        for (int i = 0; i < length; ++i) {
            names.add(ParserUtils.getDefaultColumnName(i));
        }
        return names;
    }

    @VisibleForTesting
    static Set<String> findDuplicates(Iterable<String> fieldNames) {
        HashSet<String> duplicates = new HashSet<String>();
        HashSet<String> uniqueNames = new HashSet<String>();
        for (String fieldName : fieldNames) {
            if (uniqueNames.contains(fieldName)) {
                duplicates.add(fieldName);
            }
            uniqueNames.add(fieldName);
        }
        return duplicates;
    }

    public static void validateFields(Iterable<String> fieldNames) {
        Set<String> duplicates = ParserUtils.findDuplicates(fieldNames);
        if (!duplicates.isEmpty()) {
            throw new ParseException("Duplicate column entries found : %s", duplicates.toString());
        }
    }

    public static String stripQuotes(String input) {
        if ((input = input.trim()).charAt(0) == '\"' && input.charAt(input.length() - 1) == '\"') {
            input = input.substring(1, input.length() - 1).trim();
        }
        return input;
    }

    @Nullable
    public static DateTimeZone getDateTimeZone(String timeZone) {
        return TIMEZONE_LOOKUP.get(timeZone);
    }

    public static String getDefaultColumnName(int ordinal) {
        return DEFAULT_COLUMN_NAME_PREFIX + (ordinal + 1);
    }

    static {
        for (String tz : TimeZone.getAvailableIDs()) {
            try {
                TIMEZONE_LOOKUP.put(tz, DateTimeZone.forTimeZone((TimeZone)TimeZone.getTimeZone(tz)));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }
}

