/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.java.util.common.guava;

import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.com.google.common.base.Throwables;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.Accumulator;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.Sequence;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.SequenceWrapper;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.WrappingYielder;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.Yielder;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.YieldingAccumulator;

final class WrappingSequence<T>
implements Sequence<T> {
    private final Sequence<T> baseSequence;
    private final SequenceWrapper wrapper;

    WrappingSequence(Sequence<T> baseSequence, SequenceWrapper wrapper) {
        this.baseSequence = Preconditions.checkNotNull(baseSequence, "baseSequence");
        this.wrapper = Preconditions.checkNotNull(wrapper, "wrapper");
    }

    @Override
    public <OutType> OutType accumulate(final OutType outType, final Accumulator<OutType, T> accumulator) {
        Object result;
        try {
            this.wrapper.before();
            result = this.wrapper.wrap(new Supplier<OutType>(){

                @Override
                public OutType get() {
                    return WrappingSequence.this.baseSequence.accumulate(outType, accumulator);
                }
            });
        }
        catch (Throwable t) {
            try {
                this.wrapper.after(false, t);
            }
            catch (Exception e) {
                t.addSuppressed(e);
            }
            Throwables.propagateIfPossible(t);
            throw new RuntimeException(t);
        }
        try {
            this.wrapper.after(true, null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return (OutType)result;
    }

    @Override
    public <OutType> Yielder<OutType> toYielder(final OutType initValue, final YieldingAccumulator<OutType, T> accumulator) {
        try {
            this.wrapper.before();
            return (Yielder)this.wrapper.wrap(new Supplier<Yielder<OutType>>(){

                @Override
                public Yielder<OutType> get() {
                    return new WrappingYielder<Object>(WrappingSequence.this.baseSequence.toYielder(initValue, accumulator), WrappingSequence.this.wrapper);
                }
            });
        }
        catch (Throwable t) {
            try {
                this.wrapper.after(false, t);
            }
            catch (Exception e) {
                t.addSuppressed(e);
            }
            Throwables.propagateIfPossible(t);
            throw new RuntimeException(t);
        }
    }
}

