/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.java.util.common.guava;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.Function;
import org.apache.hive.druid.com.google.common.base.Predicate;
import org.apache.hive.druid.com.google.common.collect.Ordering;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.Accumulator;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.Accumulators;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.ConcatSequence;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.LimitedSequence;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.MappedSequence;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.MergeSequence;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.Sequences;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.Yielder;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.YieldingAccumulator;

public interface Sequence<T> {
    public <OutType> OutType accumulate(OutType var1, Accumulator<OutType, T> var2);

    public <OutType> Yielder<OutType> toYielder(OutType var1, YieldingAccumulator<OutType, T> var2);

    default public <U> Sequence<U> map(Function<? super T, ? extends U> mapper) {
        return new MappedSequence<T, U>(this, mapper);
    }

    default public Sequence<T> filter(Predicate<? super T> predicate) {
        return Sequences.filter(this, predicate);
    }

    default public List<T> toList() {
        return this.accumulate(new ArrayList(), Accumulators.list());
    }

    default public Sequence<T> limit(long limit) {
        return new LimitedSequence(this, limit);
    }

    default public <R> Sequence<R> flatMap(Function<? super T, ? extends Sequence<? extends R>> mapper) {
        return new ConcatSequence(this.map(mapper));
    }

    default public <R> Sequence<R> flatMerge(Function<? super T, ? extends Sequence<? extends R>> mapper, Ordering<? super R> ordering) {
        return new MergeSequence<R>(ordering, this.map(mapper));
    }

    default public Sequence<T> withEffect(Runnable effect, Executor effectExecutor) {
        return Sequences.withEffect(this, effect, effectExecutor);
    }

    default public Sequence<T> withBaggage(Closeable baggage) {
        return Sequences.withBaggage(this, baggage);
    }
}

