/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.java.util.common.guava;

import java.util.Iterator;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.Accumulator;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.Sequence;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.Yielder;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.Yielders;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.YieldingAccumulator;

public class BaseSequence<T, IterType extends Iterator<T>>
implements Sequence<T> {
    private final IteratorMaker<T, IterType> maker;

    public BaseSequence(IteratorMaker<T, IterType> maker) {
        this.maker = maker;
    }

    @Override
    public <OutType> OutType accumulate(OutType initValue, Accumulator<OutType, T> fn) {
        IterType iterator = this.maker.make();
        OutType accumulated = initValue;
        try {
            while (iterator.hasNext()) {
                accumulated = fn.accumulate(accumulated, iterator.next());
            }
        }
        finally {
            this.maker.cleanup(iterator);
        }
        return accumulated;
    }

    @Override
    public <OutType> Yielder<OutType> toYielder(OutType initValue, YieldingAccumulator<OutType, T> accumulator) {
        IterType iterator = this.maker.make();
        try {
            return this.makeYielder(initValue, accumulator, iterator);
        }
        catch (Throwable t) {
            try {
                this.maker.cleanup(iterator);
            }
            catch (Exception e) {
                t.addSuppressed(e);
            }
            throw t;
        }
    }

    private <OutType> Yielder<OutType> makeYielder(OutType initValue, final YieldingAccumulator<OutType, T> accumulator, IterType iter) {
        OutType retVal = initValue;
        while (!accumulator.yielded() && iter.hasNext()) {
            retVal = accumulator.accumulate(retVal, iter.next());
        }
        if (!accumulator.yielded()) {
            return Yielders.done(retVal, () -> this.maker.cleanup((Iterator)iter));
        }
        final OutType finalRetVal = retVal;
        return new Yielder<OutType>((Iterator)iter){
            final /* synthetic */ Iterator val$iter;
            {
                this.val$iter = iterator;
            }

            @Override
            public OutType get() {
                return finalRetVal;
            }

            @Override
            public Yielder<OutType> next(OutType initValue) {
                accumulator.reset();
                try {
                    return BaseSequence.this.makeYielder(initValue, accumulator, this.val$iter);
                }
                catch (Throwable t) {
                    try {
                        BaseSequence.this.maker.cleanup(this.val$iter);
                    }
                    catch (Exception e) {
                        t.addSuppressed(e);
                    }
                    throw t;
                }
            }

            @Override
            public boolean isDone() {
                return false;
            }

            @Override
            public void close() {
                BaseSequence.this.maker.cleanup(this.val$iter);
            }
        };
    }

    public static interface IteratorMaker<T, IterType extends Iterator<T>> {
        public IterType make();

        public void cleanup(IterType var1);
    }
}

