/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.java.util.common.granularity;

import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.hive.druid.com.fasterxml.jackson.databind.JsonSerializable;
import org.apache.hive.druid.com.fasterxml.jackson.databind.SerializerProvider;
import org.apache.hive.druid.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.org.apache.druid.java.util.common.DateTimes;
import org.apache.hive.druid.org.apache.druid.java.util.common.IAE;
import org.apache.hive.druid.org.apache.druid.java.util.common.StringUtils;
import org.apache.hive.druid.org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.hive.druid.org.apache.druid.java.util.common.granularity.GranularityType;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.joda.time.ReadablePeriod;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class PeriodGranularity
extends Granularity
implements JsonSerializable {
    private final Period period;
    private final Chronology chronology;
    private final long origin;
    private final boolean hasOrigin;
    private final boolean isCompound;

    @JsonCreator
    public PeriodGranularity(@JsonProperty(value="period") Period period, @JsonProperty(value="origin") DateTime origin, @JsonProperty(value="timeZone") DateTimeZone tz) {
        this.period = Preconditions.checkNotNull(period, "period can't be null!");
        Preconditions.checkArgument(!Period.ZERO.equals((Object)period), "zero period is not acceptable in QueryGranularity!");
        ISOChronology iSOChronology = this.chronology = tz == null ? ISOChronology.getInstanceUTC() : ISOChronology.getInstance((DateTimeZone)tz);
        if (origin == null) {
            this.origin = new DateTime(0L, DateTimeZone.UTC).withZoneRetainFields(this.chronology.getZone()).getMillis();
            this.hasOrigin = false;
        } else {
            this.origin = origin.getMillis();
            this.hasOrigin = true;
        }
        this.isCompound = PeriodGranularity.isCompoundPeriod(period);
    }

    @JsonProperty(value="period")
    public Period getPeriod() {
        return this.period;
    }

    @JsonProperty(value="timeZone")
    public DateTimeZone getTimeZone() {
        return this.chronology.getZone();
    }

    @JsonProperty(value="origin")
    @Nullable
    public DateTime getOrigin() {
        return this.hasOrigin ? DateTimes.utc(this.origin) : null;
    }

    @Override
    public DateTimeFormatter getFormatter(Granularity.Formatter type) {
        GranularityType granularityType = GranularityType.fromPeriod(this.period);
        switch (type) {
            case DEFAULT: {
                return DateTimeFormat.forPattern((String)granularityType.getDefaultFormat());
            }
            case HIVE: {
                return DateTimeFormat.forPattern((String)granularityType.getHiveFormat());
            }
            case LOWER_DEFAULT: {
                return DateTimeFormat.forPattern((String)granularityType.getLowerDefaultFormat());
            }
        }
        throw new IAE("There is no format for type %s", new Object[]{type});
    }

    @Override
    public DateTime increment(DateTime time) {
        return new DateTime(this.increment(time.getMillis()), this.getTimeZone());
    }

    @Override
    public DateTime bucketStart(DateTime time) {
        return new DateTime(this.truncate(time.getMillis()), this.getTimeZone());
    }

    @Override
    public DateTime toDate(String filePath, Granularity.Formatter formatter) {
        Integer[] vals = this.getDateValues(filePath, formatter);
        GranularityType granularityType = GranularityType.fromPeriod(this.period);
        DateTime date = granularityType.getDateTime(vals);
        if (date != null) {
            return this.bucketStart(date);
        }
        return null;
    }

    @Override
    public boolean isAligned(Interval interval) {
        return this.bucket(interval.getStart()).equals((Object)interval);
    }

    @Override
    public byte[] getCacheKey() {
        return StringUtils.toUtf8(this.getPeriod() + ":" + this.getTimeZone() + ":" + this.getOrigin());
    }

    @Override
    public DateTime toDateTime(long offset) {
        return new DateTime(offset, this.getTimeZone());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PeriodGranularity that = (PeriodGranularity)o;
        if (this.origin != that.origin) {
            return false;
        }
        if (this.hasOrigin != that.hasOrigin) {
            return false;
        }
        if (this.isCompound != that.isCompound) {
            return false;
        }
        if (!this.period.equals((Object)that.period)) {
            return false;
        }
        return this.chronology.equals(that.chronology);
    }

    public int hashCode() {
        int result = this.period.hashCode();
        result = 31 * result + this.chronology.hashCode();
        result = 31 * result + (int)(this.origin ^ this.origin >>> 32);
        result = 31 * result + (this.hasOrigin ? 1 : 0);
        result = 31 * result + (this.isCompound ? 1 : 0);
        return result;
    }

    public String toString() {
        return "{type=period, period=" + this.getPeriod() + ", timeZone=" + this.getTimeZone() + ", origin=" + this.getOrigin() + '}';
    }

    private static boolean isCompoundPeriod(Period period) {
        int[] values = period.getValues();
        boolean single = false;
        for (int v : values) {
            if (v <= 0) continue;
            if (single) {
                return true;
            }
            single = true;
        }
        return false;
    }

    private long increment(long t) {
        return this.chronology.add((ReadablePeriod)this.period, t, 1);
    }

    private long truncate(long t) {
        if (this.isCompound) {
            try {
                return this.truncateMillisPeriod(t);
            }
            catch (UnsupportedOperationException e) {
                return this.truncateCompoundPeriod(t);
            }
        }
        int years = this.period.getYears();
        if (years > 0) {
            if (years > 1 || this.hasOrigin) {
                int y = this.chronology.years().getDifference(t, this.origin);
                y -= y % years;
                long tt = this.chronology.years().add(this.origin, y);
                t = t < tt ? this.chronology.years().add(tt, -years) : tt;
                return t;
            }
            return this.chronology.year().roundFloor(t);
        }
        int months = this.period.getMonths();
        if (months > 0) {
            if (months > 1 || this.hasOrigin) {
                int m = this.chronology.months().getDifference(t, this.origin);
                m -= m % months;
                long tt = this.chronology.months().add(this.origin, m);
                t = t < tt ? this.chronology.months().add(tt, -months) : tt;
                return t;
            }
            return this.chronology.monthOfYear().roundFloor(t);
        }
        int weeks = this.period.getWeeks();
        if (weeks > 0) {
            if (weeks > 1 || this.hasOrigin) {
                int w = this.chronology.weeks().getDifference(t, this.origin);
                w -= w % weeks;
                long tt = this.chronology.weeks().add(this.origin, w);
                t = t < tt ? this.chronology.weeks().add(tt, -weeks) : tt;
                return t;
            }
            t = this.chronology.dayOfWeek().roundFloor(t);
            return this.chronology.dayOfWeek().set(t, 1);
        }
        int days = this.period.getDays();
        if (days > 0) {
            if (days > 1 || this.hasOrigin) {
                int d = this.chronology.days().getDifference(t, this.origin);
                d -= d % days;
                long tt = this.chronology.days().add(this.origin, d);
                t = t < tt ? this.chronology.days().add(tt, -days) : tt;
                return t;
            }
            return this.chronology.dayOfMonth().roundFloor(t);
        }
        int hours = this.period.getHours();
        if (hours > 0) {
            if (hours > 1 || this.hasOrigin) {
                long h = this.chronology.hours().getDifferenceAsLong(t, this.origin);
                h -= h % (long)hours;
                long tt = this.chronology.hours().add(this.origin, h);
                if (t < tt && this.origin > 0L) {
                    t = this.chronology.hours().add(tt, -hours);
                } else if (t > tt && this.origin < 0L) {
                    t = this.chronology.minuteOfHour().roundFloor(tt);
                    t = this.chronology.minuteOfHour().set(t, 0);
                } else {
                    t = tt;
                }
                return t;
            }
            return this.chronology.hourOfDay().roundFloor(t);
        }
        int minutes = this.period.getMinutes();
        if (minutes > 0) {
            if (minutes > 1 || this.hasOrigin) {
                long m = this.chronology.minutes().getDifferenceAsLong(t, this.origin);
                m -= m % (long)minutes;
                long tt = this.chronology.minutes().add(this.origin, m);
                t = t < tt ? this.chronology.minutes().add(tt, -minutes) : tt;
                return t;
            }
            return this.chronology.minuteOfHour().roundFloor(t);
        }
        int seconds = this.period.getSeconds();
        if (seconds > 0) {
            if (seconds > 1 || this.hasOrigin) {
                long s = this.chronology.seconds().getDifferenceAsLong(t, this.origin);
                s -= s % (long)seconds;
                long tt = this.chronology.seconds().add(this.origin, s);
                t = t < tt ? this.chronology.seconds().add(tt, -seconds) : tt;
                return t;
            }
            return this.chronology.millisOfSecond().set(t, 0);
        }
        int millis = this.period.getMillis();
        if (millis > 0) {
            if (millis > 1) {
                long ms = this.chronology.millis().getDifferenceAsLong(t, this.origin);
                ms -= ms % (long)millis;
                long tt = this.chronology.millis().add(this.origin, ms);
                t = t < tt ? this.chronology.millis().add(tt, -millis) : tt;
                return t;
            }
            return t;
        }
        return t;
    }

    private long truncateCompoundPeriod(long t) {
        long current;
        if (t >= this.origin) {
            long next = this.origin;
            while (t >= (next = this.chronology.add((ReadablePeriod)this.period, current = next, 1))) {
            }
        } else {
            current = this.origin;
            while (t < (current = this.chronology.add((ReadablePeriod)this.period, current, -1))) {
            }
        }
        return current;
    }

    private long truncateMillisPeriod(long t) {
        if (this.chronology.days().isPrecise() && this.chronology.hours().isPrecise()) {
            long millis = this.period.toStandardDuration().getMillis();
            long offset = t % millis - this.origin % millis;
            if (offset < 0L) {
                offset += millis;
            }
            return t - offset;
        }
        throw new UnsupportedOperationException("Period cannot be converted to milliseconds as some fields mays vary in length with chronology " + this.chronology);
    }

    @Override
    public void serialize(JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        if (GranularityType.isStandard(this)) {
            jsonGenerator.writeString(GranularityType.fromPeriod(this.getPeriod()).toString());
        } else {
            jsonGenerator.writeStartObject();
            jsonGenerator.writeStringField("type", "period");
            jsonGenerator.writeObjectField("period", this.getPeriod());
            jsonGenerator.writeObjectField("timeZone", this.getTimeZone());
            jsonGenerator.writeObjectField("origin", this.getOrigin());
            jsonGenerator.writeEndObject();
        }
    }

    @Override
    public void serializeWithType(JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException {
        this.serialize(jsonGenerator, serializerProvider);
    }
}

