/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.java.util.common.concurrent;

import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.google.common.util.concurrent.FutureCallback;
import org.apache.hive.druid.com.google.common.util.concurrent.Futures;
import org.apache.hive.druid.com.google.common.util.concurrent.ListenableFuture;
import org.apache.hive.druid.com.google.common.util.concurrent.SettableFuture;

public class ListenableFutures {
    public static <I, O> ListenableFuture<O> transformAsync(ListenableFuture<I> inFuture, final Function<I, ListenableFuture<O>> transform) {
        final SettableFuture finalFuture = SettableFuture.create();
        Futures.addCallback(inFuture, new FutureCallback<I>(){

            @Override
            public void onSuccess(@Nullable I result) {
                ListenableFuture transformFuture = (ListenableFuture)transform.apply(result);
                Futures.addCallback(transformFuture, new FutureCallback<O>(){

                    @Override
                    public void onSuccess(@Nullable O result) {
                        finalFuture.set(result);
                    }

                    @Override
                    public void onFailure(Throwable t) {
                        finalFuture.setException(t);
                    }
                });
            }

            @Override
            public void onFailure(Throwable t) {
                finalFuture.setException(t);
            }
        });
        return finalFuture;
    }
}

