/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.java.util.common;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.IllegalFormatException;
import java.util.Locale;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.google.common.base.Strings;

public class StringUtils {
    public static final byte[] EMPTY_BYTES = new byte[0];
    @Deprecated
    public static final Charset UTF8_CHARSET = StandardCharsets.UTF_8;
    public static final String UTF8_STRING = StandardCharsets.UTF_8.toString();
    private static final Base64.Encoder BASE64_ENCODER = Base64.getEncoder();
    private static final Base64.Decoder BASE64_DECODER = Base64.getDecoder();

    public static int estimatedBinaryLengthAsUTF8(String value) {
        int length = 0;
        for (int i = 0; i < value.length(); ++i) {
            char var10 = value.charAt(i);
            if (var10 < '\u0080') {
                ++length;
                continue;
            }
            if (var10 < '\u0800') {
                length += 2;
                continue;
            }
            if (Character.isSurrogate(var10)) {
                length += 4;
                ++i;
                continue;
            }
            length += 3;
        }
        return length;
    }

    public static byte[] toUtf8WithNullToEmpty(String string) {
        return string == null ? EMPTY_BYTES : StringUtils.toUtf8(string);
    }

    public static String fromUtf8(byte[] bytes) {
        try {
            return new String(bytes, UTF8_STRING);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String fromUtf8(ByteBuffer buffer, int numBytes) {
        byte[] bytes = new byte[numBytes];
        buffer.get(bytes);
        return StringUtils.fromUtf8(bytes);
    }

    public static String fromUtf8(ByteBuffer buffer) {
        return StringUtils.fromUtf8(buffer, buffer.remaining());
    }

    public static byte[] toUtf8(String string) {
        try {
            return string.getBytes(UTF8_STRING);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int toUtf8WithLimit(String string, ByteBuffer byteBuffer) {
        CharsetEncoder encoder = StandardCharsets.UTF_8.newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        int originalPosition = byteBuffer.position();
        int originalLimit = byteBuffer.limit();
        int maxBytes = byteBuffer.remaining();
        try {
            char[] chars = string.toCharArray();
            CharBuffer charBuffer = CharBuffer.wrap(chars);
            encoder.encode(charBuffer, byteBuffer, true);
            int bytesWritten = byteBuffer.position() - originalPosition;
            assert (bytesWritten <= maxBytes);
            int n = bytesWritten;
            return n;
        }
        finally {
            byteBuffer.position(originalPosition);
            byteBuffer.limit(originalLimit);
        }
    }

    @Nullable
    public static byte[] toUtf8Nullable(@Nullable String string) {
        if (string == null) {
            return null;
        }
        return StringUtils.toUtf8(string);
    }

    public static String format(String message, Object ... formatArgs) {
        return String.format(Locale.ENGLISH, message, formatArgs);
    }

    public static String nonStrictFormat(String message, Object ... formatArgs) {
        if (formatArgs == null || formatArgs.length == 0) {
            return message;
        }
        try {
            return String.format(Locale.ENGLISH, message, formatArgs);
        }
        catch (IllegalFormatException e) {
            StringBuilder bob = new StringBuilder(message);
            for (Object formatArg : formatArgs) {
                bob.append("; ").append(formatArg);
            }
            return bob.toString();
        }
    }

    public static String toLowerCase(String s) {
        return s.toLowerCase(Locale.ENGLISH);
    }

    public static String toUpperCase(String s) {
        return s.toUpperCase(Locale.ENGLISH);
    }

    @Nullable
    public static String urlEncode(@Nullable String s) {
        if (s == null) {
            return null;
        }
        try {
            return StringUtils.replace(URLEncoder.encode(s, "UTF-8"), "+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable
    public static String urlDecode(String s) {
        if (s == null) {
            return null;
        }
        try {
            return URLDecoder.decode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String maybeRemoveLeadingSlash(String s) {
        return s != null && s.startsWith("/") ? s.substring(1) : s;
    }

    public static String maybeRemoveTrailingSlash(String s) {
        return s != null && s.endsWith("/") ? s.substring(0, s.length() - 1) : s;
    }

    public static String removeChar(String s, char c) {
        int pos = s.indexOf(c);
        if (pos < 0) {
            return s;
        }
        StringBuilder sb = new StringBuilder(s.length() - 1);
        int prevPos = 0;
        do {
            sb.append(s, prevPos, pos);
            prevPos = pos + 1;
        } while ((pos = s.indexOf(c, pos + 1)) > 0);
        sb.append(s, prevPos, s.length());
        return sb.toString();
    }

    public static String replaceChar(String s, char c, String replacement) {
        int pos = s.indexOf(c);
        if (pos < 0) {
            return s;
        }
        StringBuilder sb = new StringBuilder(s.length() - 1 + replacement.length());
        int prevPos = 0;
        do {
            sb.append(s, prevPos, pos);
            sb.append(replacement);
            prevPos = pos + 1;
        } while ((pos = s.indexOf(c, pos + 1)) > 0);
        sb.append(s, prevPos, s.length());
        return sb.toString();
    }

    public static String replace(String s, String target, String replacement) {
        int pos = s.indexOf(target);
        if (pos < 0) {
            return s;
        }
        int sLength = s.length();
        int targetLength = target.length();
        int searchSkip = Math.max(targetLength, 1);
        StringBuilder sb = new StringBuilder(sLength - targetLength + replacement.length());
        int prevPos = 0;
        do {
            sb.append(s, prevPos, pos);
            sb.append(replacement);
            prevPos = pos + targetLength;
        } while (pos != sLength && (pos = s.indexOf(target, pos + searchSkip)) > 0);
        sb.append(s, prevPos, sLength);
        return sb.toString();
    }

    public static String nullToEmptyNonDruidDataString(@Nullable String string) {
        return Strings.nullToEmpty(string);
    }

    @Nullable
    public static String emptyToNullNonDruidDataString(@Nullable String string) {
        return Strings.emptyToNull(string);
    }

    public static String utf8Base64(String input) {
        return StringUtils.fromUtf8(StringUtils.encodeBase64(StringUtils.toUtf8(input)));
    }

    public static byte[] encodeBase64(byte[] input) {
        return BASE64_ENCODER.encode(input);
    }

    public static String encodeBase64String(byte[] input) {
        return BASE64_ENCODER.encodeToString(input);
    }

    public static byte[] decodeBase64(byte[] input) {
        return BASE64_DECODER.decode(input);
    }

    public static byte[] decodeBase64String(String input) {
        return BASE64_DECODER.decode(input);
    }

    public static String repeat(String s, int count) {
        int copied;
        if (count < 0) {
            throw new IllegalArgumentException("count is negative, " + count);
        }
        if (count == 1) {
            return s;
        }
        byte[] value = s.getBytes(StandardCharsets.UTF_8);
        int len = value.length;
        if (len == 0 || count == 0) {
            return "";
        }
        if (len == 1) {
            byte[] single = new byte[count];
            Arrays.fill(single, value[0]);
            return new String(single, StandardCharsets.UTF_8);
        }
        if (Integer.MAX_VALUE / count < len) {
            throw new RuntimeException("The produced string is too large.");
        }
        int limit = len * count;
        byte[] multiple = new byte[limit];
        System.arraycopy(value, 0, multiple, 0, len);
        for (copied = len; copied < limit - copied; copied <<= 1) {
            System.arraycopy(multiple, 0, multiple, copied, copied);
        }
        System.arraycopy(multiple, 0, multiple, copied, limit - copied);
        return new String(multiple, StandardCharsets.UTF_8);
    }

    public static String lpad(String base, Integer len, String pad) {
        int i;
        if (len < 0) {
            return null;
        }
        if (len == 0) {
            return "";
        }
        char[] data = new char[len.intValue()];
        int pos = Math.max(len - base.length(), 0);
        for (i = 0; i < pos; i += pad.length()) {
            for (int j = 0; j < pad.length() && j < pos - i; ++j) {
                data[i + j] = pad.charAt(j);
            }
        }
        for (i = 0; pos + i < len && i < base.length(); ++i) {
            data[pos + i] = base.charAt(i);
        }
        return new String(data);
    }

    public static String rpad(String base, Integer len, String pad) {
        int pos;
        if (len < 0) {
            return null;
        }
        if (len == 0) {
            return "";
        }
        char[] data = new char[len.intValue()];
        for (pos = 0; pos < base.length() && pos < len; ++pos) {
            data[pos] = base.charAt(pos);
        }
        while (pos < len) {
            for (int i = 0; i < pad.length() && i < len - pos; ++i) {
                data[pos + i] = pad.charAt(i);
            }
            pos += pad.length();
        }
        return new String(data);
    }

    @Nullable
    public static String chop(@Nullable String s, int maxBytes) {
        if (s == null) {
            return null;
        }
        byte[] bytes = new byte[maxBytes];
        int len = StringUtils.toUtf8WithLimit(s, ByteBuffer.wrap(bytes));
        return new String(bytes, 0, len, StandardCharsets.UTF_8);
    }

    @Nullable
    public static String fastLooseChop(@Nullable String s, int maxBytes) {
        if (s == null || s.length() <= maxBytes) {
            return s;
        }
        return s.substring(0, maxBytes);
    }
}

