/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.java.util.common;

import java.util.Map;
import org.apache.hive.druid.org.apache.druid.java.util.common.IAE;

public class MapUtils {
    public static String getString(Map<String, Object> in, String key) {
        return MapUtils.getString(in, key, null);
    }

    public static String getString(Map<String, Object> in, String key, String defaultValue) {
        Object retVal = in.get(key);
        if (retVal == null) {
            if (defaultValue == null) {
                throw new IAE("Key[%s] is required in map[%s]", key, in);
            }
            return defaultValue;
        }
        return retVal.toString();
    }

    public static int getInt(Map<String, Object> in, String key, Integer defaultValue) {
        Object retVal = in.get(key);
        if (retVal == null) {
            if (defaultValue == null) {
                throw new IAE("Key[%s] is required in map[%s]", key, in);
            }
            return defaultValue;
        }
        try {
            return Integer.parseInt(retVal.toString());
        }
        catch (NumberFormatException e) {
            throw new IAE(e, "Key[%s] should be an int, was[%s]", key, retVal);
        }
    }

    public static long getLong(Map<String, Object> in, String key, Long defaultValue) {
        Object retVal = in.get(key);
        if (retVal == null) {
            if (defaultValue == null) {
                throw new IAE("Key[%s] is required in map[%s]", key, in);
            }
            return defaultValue;
        }
        try {
            return Long.parseLong(retVal.toString());
        }
        catch (NumberFormatException e) {
            throw new IAE(e, "Key[%s] should be a long, was[%s]", key, retVal);
        }
    }
}

