/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.jackson;

import java.io.IOException;
import java.nio.ByteOrder;
import org.apache.hive.druid.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.hive.druid.com.fasterxml.jackson.core.JsonParser;
import org.apache.hive.druid.com.fasterxml.jackson.databind.DeserializationContext;
import org.apache.hive.druid.com.fasterxml.jackson.databind.JsonDeserializer;
import org.apache.hive.druid.com.fasterxml.jackson.databind.JsonSerializer;
import org.apache.hive.druid.com.fasterxml.jackson.databind.SerializerProvider;
import org.apache.hive.druid.com.fasterxml.jackson.databind.module.SimpleModule;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import org.apache.hive.druid.org.apache.druid.jackson.JodaStuff;
import org.apache.hive.druid.org.apache.druid.java.util.common.DateTimes;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.Accumulator;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.Sequence;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.Yielder;
import org.joda.time.DateTimeZone;

public class DruidDefaultSerializersModule
extends SimpleModule {
    public DruidDefaultSerializersModule() {
        super("Druid default serializers");
        JodaStuff.register(this);
        this.addDeserializer(DateTimeZone.class, new JsonDeserializer<DateTimeZone>(){

            @Override
            public DateTimeZone deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
                String tzId = jp.getText();
                return DateTimes.inferTzFromString(tzId);
            }
        });
        this.addSerializer(DateTimeZone.class, new JsonSerializer<DateTimeZone>(){

            @Override
            public void serialize(DateTimeZone dateTimeZone, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
                jsonGenerator.writeString(dateTimeZone.getID());
            }
        });
        this.addSerializer(Sequence.class, new JsonSerializer<Sequence>(){

            @Override
            public void serialize(Sequence value, final JsonGenerator jgen, SerializerProvider provider) throws IOException {
                jgen.writeStartArray();
                value.accumulate(null, new Accumulator<Object, Object>(){

                    @Override
                    public Object accumulate(Object o, Object o1) {
                        try {
                            jgen.writeObject(o1);
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                        return null;
                    }
                });
                jgen.writeEndArray();
            }
        });
        this.addSerializer(Yielder.class, new JsonSerializer<Yielder>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void serialize(Yielder yielder, JsonGenerator jgen, SerializerProvider provider) throws IOException {
                try {
                    jgen.writeStartArray();
                    while (!yielder.isDone()) {
                        Object o = yielder.get();
                        jgen.writeObject(o);
                        yielder = yielder.next(null);
                    }
                    jgen.writeEndArray();
                }
                finally {
                    yielder.close();
                }
            }
        });
        this.addSerializer(ByteOrder.class, ToStringSerializer.instance);
        this.addDeserializer(ByteOrder.class, new JsonDeserializer<ByteOrder>(){

            @Override
            public ByteOrder deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
                if (ByteOrder.BIG_ENDIAN.toString().equals(jp.getText())) {
                    return ByteOrder.BIG_ENDIAN;
                }
                return ByteOrder.LITTLE_ENDIAN;
            }
        });
    }
}

