/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.inputsource.hdfs;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JacksonInject;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.org.apache.druid.data.input.AbstractInputSource;
import org.apache.hive.druid.org.apache.druid.data.input.InputFormat;
import org.apache.hive.druid.org.apache.druid.data.input.InputRowSchema;
import org.apache.hive.druid.org.apache.druid.data.input.InputSourceReader;
import org.apache.hive.druid.org.apache.druid.data.input.InputSplit;
import org.apache.hive.druid.org.apache.druid.data.input.SplitHintSpec;
import org.apache.hive.druid.org.apache.druid.data.input.impl.InputEntityIteratingReader;
import org.apache.hive.druid.org.apache.druid.data.input.impl.SplittableInputSource;
import org.apache.hive.druid.org.apache.druid.guice.Hdfs;
import org.apache.hive.druid.org.apache.druid.inputsource.hdfs.HdfsInputEntity;
import org.apache.hive.druid.org.apache.druid.java.util.common.IAE;

public class HdfsInputSource
extends AbstractInputSource
implements SplittableInputSource<Path> {
    private static final String PROP_PATHS = "paths";
    private final List<String> inputPaths;
    private final Configuration configuration;
    private List<Path> cachedPaths;

    @JsonCreator
    public HdfsInputSource(@JsonProperty(value="paths") Object inputPaths, @JacksonInject @Hdfs Configuration configuration) {
        this.inputPaths = HdfsInputSource.coerceInputPathsToList(inputPaths, PROP_PATHS);
        this.configuration = configuration;
        this.cachedPaths = null;
    }

    public static List<String> coerceInputPathsToList(Object inputPaths, String propertyName) {
        List<String> paths;
        if (inputPaths instanceof String) {
            paths = Collections.singletonList((String)inputPaths);
        } else if (inputPaths instanceof List && ((List)inputPaths).stream().allMatch(x -> x instanceof String)) {
            paths = ((List)inputPaths).stream().map(x -> (String)x).collect(Collectors.toList());
        } else {
            throw new IAE("'%s' must be a string or an array of strings", propertyName);
        }
        return paths;
    }

    public static Collection<Path> getPaths(List<String> inputPaths, Configuration configuration) throws IOException {
        if (inputPaths.isEmpty()) {
            return Collections.emptySet();
        }
        Job job = Job.getInstance((Configuration)configuration);
        for (String inputPath : inputPaths) {
            FileInputFormat.addInputPaths((Job)job, (String)inputPath);
        }
        return new HdfsFileInputFormat().getSplits((JobContext)job).stream().map(split -> ((FileSplit)split).getPath()).collect(Collectors.toSet());
    }

    @JsonProperty(value="paths")
    private List<String> getInputPaths() {
        return this.inputPaths;
    }

    @Override
    protected InputSourceReader formattableReader(InputRowSchema inputRowSchema, InputFormat inputFormat, @Nullable File temporaryDirectory) {
        Stream<InputSplit<Path>> splits;
        try {
            splits = this.createSplits(inputFormat, null);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return new InputEntityIteratingReader(inputRowSchema, inputFormat, splits.map(split -> new HdfsInputEntity(this.configuration, (Path)split.get())), temporaryDirectory);
    }

    @Override
    public Stream<InputSplit<Path>> createSplits(InputFormat inputFormat, @Nullable SplitHintSpec splitHintSpec) throws IOException {
        this.cachePathsIfNeeded();
        return this.cachedPaths.stream().map(InputSplit::new);
    }

    @Override
    public int estimateNumSplits(InputFormat inputFormat, @Nullable SplitHintSpec splitHintSpec) throws IOException {
        this.cachePathsIfNeeded();
        return this.cachedPaths.size();
    }

    @Override
    public SplittableInputSource<Path> withSplit(InputSplit<Path> split) {
        return new HdfsInputSource(split.get().toString(), this.configuration);
    }

    @Override
    public boolean needsFormat() {
        return true;
    }

    private void cachePathsIfNeeded() throws IOException {
        if (this.cachedPaths == null) {
            this.cachedPaths = ImmutableList.copyOf(Preconditions.checkNotNull(HdfsInputSource.getPaths(this.inputPaths, this.configuration), PROP_PATHS));
        }
    }

    static Builder builder() {
        return new Builder();
    }

    static final class Builder {
        private Object paths;
        private Configuration configuration;

        private Builder() {
        }

        Builder paths(Object paths) {
            this.paths = paths;
            return this;
        }

        Builder configuration(Configuration configuration) {
            this.configuration = configuration;
            return this;
        }

        HdfsInputSource build() {
            return new HdfsInputSource(this.paths, this.configuration);
        }
    }

    private static class HdfsFileInputFormat
    extends FileInputFormat<Object, Object> {
        private HdfsFileInputFormat() {
        }

        public RecordReader<Object, Object> createRecordReader(org.apache.hadoop.mapreduce.InputSplit inputSplit, TaskAttemptContext taskAttemptContext) {
            throw new UnsupportedOperationException();
        }

        protected boolean isSplitable(JobContext context, Path filename) {
            return false;
        }
    }
}

