/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.indexing.overlord.supervisor;

import java.util.Objects;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.hive.druid.com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.org.apache.druid.indexing.overlord.supervisor.SupervisorSpec;

@JsonDeserialize(builder=Builder.class)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class SupervisorStatus {
    private final String id;
    private final String state;
    private final String detailedState;
    private final boolean healthy;
    private final SupervisorSpec spec;
    private final String specString;
    private final String type;
    private final String source;
    private final boolean suspended;

    private SupervisorStatus(Builder builder) {
        this.id = Preconditions.checkNotNull(builder.id, "id");
        this.state = builder.state;
        this.detailedState = builder.detailedState;
        this.healthy = builder.healthy;
        this.spec = builder.spec;
        this.specString = builder.specString;
        this.type = builder.type;
        this.source = builder.source;
        this.suspended = builder.suspended;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SupervisorStatus that = (SupervisorStatus)o;
        return this.healthy == that.healthy && Objects.equals(this.id, that.id) && Objects.equals(this.state, that.state) && Objects.equals(this.detailedState, that.detailedState) && Objects.equals(this.spec, that.spec) && Objects.equals(this.specString, that.specString) && Objects.equals(this.type, that.type) && Objects.equals(this.source, that.source) && this.suspended == that.suspended;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.state, this.detailedState, this.healthy, this.spec, this.specString, this.type, this.source, this.suspended);
    }

    @JsonProperty
    public String getId() {
        return this.id;
    }

    @JsonProperty
    public String getState() {
        return this.state;
    }

    @JsonProperty
    public String getDetailedState() {
        return this.detailedState;
    }

    @JsonProperty
    public boolean isHealthy() {
        return this.healthy;
    }

    @JsonProperty
    public SupervisorSpec getSpec() {
        return this.spec;
    }

    @JsonProperty
    public String getSpecString() {
        return this.specString;
    }

    @JsonProperty
    public String getType() {
        return this.type;
    }

    @JsonProperty
    public String getSource() {
        return this.source;
    }

    @JsonProperty
    public boolean isSuspended() {
        return this.suspended;
    }

    @JsonPOJOBuilder
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="state")
        private String state;
        @JsonProperty(value="detailedState")
        private String detailedState;
        @JsonProperty(value="healthy")
        private boolean healthy;
        @JsonProperty(value="spec")
        private SupervisorSpec spec;
        @JsonProperty(value="specString")
        private String specString;
        @JsonProperty(value="type")
        private String type;
        @JsonProperty(value="source")
        private String source;
        @JsonProperty(value="suspended")
        private boolean suspended;

        @JsonProperty
        public Builder withId(String id) {
            this.id = Preconditions.checkNotNull(id, "id");
            return this;
        }

        @JsonProperty
        public Builder withState(String state) {
            this.state = state;
            return this;
        }

        @JsonProperty
        public Builder withDetailedState(String detailedState) {
            this.detailedState = detailedState;
            return this;
        }

        @JsonProperty
        public Builder withHealthy(boolean healthy) {
            this.healthy = healthy;
            return this;
        }

        @JsonProperty
        public Builder withSpec(SupervisorSpec spec) {
            this.spec = spec;
            return this;
        }

        @JsonProperty
        public Builder withSpecString(String spec) {
            this.specString = spec;
            return this;
        }

        @JsonProperty
        public Builder withType(String type) {
            this.type = type;
            return this;
        }

        @JsonProperty
        public Builder withSource(String source) {
            this.source = source;
            return this;
        }

        @JsonProperty
        public Builder withSuspended(boolean suspended) {
            this.suspended = suspended;
            return this;
        }

        public SupervisorStatus build() {
            return new SupervisorStatus(this);
        }
    }
}

