/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.indexing.overlord;

import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.collect.ImmutableSet;
import org.apache.hive.druid.org.apache.druid.timeline.DataSegment;

public class SegmentPublishResult {
    private final Set<DataSegment> segments;
    private final boolean success;
    @Nullable
    private final String errorMsg;

    public static SegmentPublishResult ok(Set<DataSegment> segments) {
        return new SegmentPublishResult(segments, true, null);
    }

    public static SegmentPublishResult fail(String errorMsg) {
        return new SegmentPublishResult(ImmutableSet.of(), false, errorMsg);
    }

    @JsonCreator
    private SegmentPublishResult(@JsonProperty(value="segments") Set<DataSegment> segments, @JsonProperty(value="success") boolean success, @JsonProperty(value="errorMsg") @Nullable String errorMsg) {
        this.segments = Preconditions.checkNotNull(segments, "segments");
        this.success = success;
        this.errorMsg = errorMsg;
        if (!success) {
            Preconditions.checkArgument(segments.isEmpty(), "segments must be empty for unsuccessful publishes");
        }
    }

    @JsonProperty
    public Set<DataSegment> getSegments() {
        return this.segments;
    }

    @JsonProperty
    public boolean isSuccess() {
        return this.success;
    }

    @JsonProperty
    @Nullable
    public String getErrorMsg() {
        return this.errorMsg;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SegmentPublishResult that = (SegmentPublishResult)o;
        return this.success == that.success && Objects.equals(this.segments, that.segments) && Objects.equals(this.errorMsg, that.errorMsg);
    }

    public int hashCode() {
        return Objects.hash(this.segments, this.success, this.errorMsg);
    }

    public String toString() {
        return "SegmentPublishResult{segments=" + this.segments + ", success=" + this.success + ", errorMsg='" + this.errorMsg + '\'' + '}';
    }
}

