/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.guice.http;

import javax.validation.constraints.Min;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.org.apache.druid.java.util.common.logger.Logger;
import org.apache.hive.druid.org.apache.druid.utils.JvmUtils;
import org.joda.time.Duration;
import org.joda.time.Period;
import org.joda.time.ReadableDuration;

public class DruidHttpClientConfig {
    private final String DEFAULT_COMPRESSION_CODEC = "gzip";
    private static final Logger LOG = new Logger(DruidHttpClientConfig.class);
    @JsonProperty
    @Min(value=0L)
    private int numConnections = 20;
    @JsonProperty
    private Period readTimeout = new Period((Object)"PT15M");
    @JsonProperty
    @Min(value=1L)
    private int numMaxThreads = Math.max(10, JvmUtils.getRuntimeInfo().getAvailableProcessors() * 17 / 16 + 2) + 30;
    @JsonProperty
    @Min(value=1L)
    private int numRequestsQueued = 1024;
    @JsonProperty
    private String compressionCodec = "gzip";
    @JsonProperty
    private int requestBuffersize = 8192;
    @JsonProperty
    private Period unusedConnectionTimeout = new Period((Object)"PT4M");
    @JsonProperty
    private long maxQueuedBytes = 0L;

    public int getNumConnections() {
        return this.numConnections;
    }

    public Duration getReadTimeout() {
        return this.readTimeout == null ? null : this.readTimeout.toStandardDuration();
    }

    public int getNumMaxThreads() {
        return this.numMaxThreads;
    }

    public String getCompressionCodec() {
        return this.compressionCodec;
    }

    public int getNumRequestsQueued() {
        return this.numRequestsQueued;
    }

    public int getRequestBuffersize() {
        return this.requestBuffersize;
    }

    public Duration getUnusedConnectionTimeout() {
        if (this.unusedConnectionTimeout != null && this.readTimeout != null && this.unusedConnectionTimeout.toStandardDuration().compareTo((ReadableDuration)this.readTimeout.toStandardDuration()) >= 0) {
            LOG.warn("Ohh no! UnusedConnectionTimeout[%s] is longer than readTimeout[%s], please correct the configuration, this might not be supported in future.", this.unusedConnectionTimeout, this.readTimeout);
        }
        return this.unusedConnectionTimeout == null ? null : this.unusedConnectionTimeout.toStandardDuration();
    }

    public long getMaxQueuedBytes() {
        return this.maxQueuedBytes;
    }
}

