/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.guice;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.ProvisionException;
import com.google.inject.util.Providers;
import javax.annotation.Nullable;
import org.apache.hive.druid.org.apache.druid.client.DruidServerConfig;
import org.apache.hive.druid.org.apache.druid.discovery.DataNodeService;
import org.apache.hive.druid.org.apache.druid.guice.JsonConfigProvider;
import org.apache.hive.druid.org.apache.druid.guice.LazySingleton;
import org.apache.hive.druid.org.apache.druid.guice.ServerTypeConfig;
import org.apache.hive.druid.org.apache.druid.guice.annotations.Self;
import org.apache.hive.druid.org.apache.druid.query.DruidProcessingConfig;
import org.apache.hive.druid.org.apache.druid.segment.column.ColumnConfig;
import org.apache.hive.druid.org.apache.druid.segment.loading.SegmentLoaderConfig;
import org.apache.hive.druid.org.apache.druid.server.DruidNode;
import org.apache.hive.druid.org.apache.druid.server.coordination.DruidServerMetadata;

public class StorageNodeModule
implements Module {
    public void configure(Binder binder) {
        JsonConfigProvider.bind(binder, "druid.server", DruidServerConfig.class);
        JsonConfigProvider.bind(binder, "druid.segmentCache", SegmentLoaderConfig.class);
        binder.bind(ServerTypeConfig.class).toProvider(Providers.of(null));
        binder.bind(ColumnConfig.class).to(DruidProcessingConfig.class);
    }

    @Provides
    @LazySingleton
    public DruidServerMetadata getMetadata(@Self DruidNode node, @Nullable ServerTypeConfig serverTypeConfig, DruidServerConfig config) {
        if (serverTypeConfig == null) {
            throw new ProvisionException("Must override the binding for ServerTypeConfig if you want a DruidServerMetadata.");
        }
        return new DruidServerMetadata(node.getHostAndPortToUse(), node.getHostAndPort(), node.getHostAndTlsPort(), config.getMaxSize(), serverTypeConfig.getServerType(), config.getTier(), config.getPriority());
    }

    @Provides
    @LazySingleton
    public DataNodeService getDataNodeService(@Nullable ServerTypeConfig serverTypeConfig, DruidServerConfig config) {
        if (serverTypeConfig == null) {
            throw new ProvisionException("Must override the binding for ServerTypeConfig if you want a DruidServerMetadata.");
        }
        return new DataNodeService(config.getTier(), config.getMaxSize(), serverTypeConfig.getServerType(), config.getPriority());
    }
}

