/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.discovery;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BooleanSupplier;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.ImmutableSet;
import org.apache.hive.druid.org.apache.druid.discovery.DiscoveryDruidNode;
import org.apache.hive.druid.org.apache.druid.discovery.DruidNodeDiscovery;
import org.apache.hive.druid.org.apache.druid.discovery.NodeRole;
import org.apache.hive.druid.org.apache.druid.java.util.common.IAE;
import org.apache.hive.druid.org.apache.druid.java.util.common.logger.Logger;
import org.apache.hive.druid.org.apache.druid.server.DruidNode;

public abstract class DruidNodeDiscoveryProvider {
    private static final Map<String, Set<NodeRole>> SERVICE_TO_NODE_TYPES = ImmutableMap.of("lookupNodeService", ImmutableSet.of(NodeRole.BROKER, NodeRole.HISTORICAL, NodeRole.PEON, NodeRole.INDEXER), "dataNodeService", ImmutableSet.of(NodeRole.HISTORICAL, NodeRole.PEON, NodeRole.INDEXER), "workerNodeService", ImmutableSet.of(NodeRole.MIDDLE_MANAGER, NodeRole.INDEXER));
    private final ConcurrentHashMap<String, ServiceDruidNodeDiscovery> serviceDiscoveryMap = new ConcurrentHashMap(SERVICE_TO_NODE_TYPES.size());

    public abstract BooleanSupplier getForNode(DruidNode var1, NodeRole var2);

    public abstract DruidNodeDiscovery getForNodeRole(NodeRole var1);

    public DruidNodeDiscovery getForService(String serviceName) {
        return this.serviceDiscoveryMap.computeIfAbsent(serviceName, service -> {
            Set<NodeRole> nodeRolesToWatch = SERVICE_TO_NODE_TYPES.get(service);
            if (nodeRolesToWatch == null) {
                throw new IAE("Unknown service [%s].", service);
            }
            ServiceDruidNodeDiscovery serviceDiscovery = new ServiceDruidNodeDiscovery((String)service, nodeRolesToWatch.size());
            DruidNodeDiscovery.Listener filteringGatheringUpstreamListener = serviceDiscovery.filteringUpstreamListener();
            for (NodeRole nodeRole : nodeRolesToWatch) {
                this.getForNodeRole(nodeRole).registerListener(filteringGatheringUpstreamListener);
            }
            return serviceDiscovery;
        });
    }

    private static class ServiceDruidNodeDiscovery
    implements DruidNodeDiscovery {
        private static final Logger log = new Logger(ServiceDruidNodeDiscovery.class);
        private final String service;
        private final ConcurrentMap<String, DiscoveryDruidNode> nodes = new ConcurrentHashMap<String, DiscoveryDruidNode>();
        private final Collection<DiscoveryDruidNode> unmodifiableNodes = Collections.unmodifiableCollection(this.nodes.values());
        private final List<DruidNodeDiscovery.Listener> listeners = new ArrayList<DruidNodeDiscovery.Listener>();
        private final Object lock = new Object();
        private int uninitializedNodeRoles;

        ServiceDruidNodeDiscovery(String service, int watchedNodeRoles) {
            Preconditions.checkArgument(watchedNodeRoles > 0);
            this.service = service;
            this.uninitializedNodeRoles = watchedNodeRoles;
        }

        @Override
        public Collection<DiscoveryDruidNode> getAllNodes() {
            return this.unmodifiableNodes;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void registerListener(DruidNodeDiscovery.Listener listener) {
            if (listener instanceof FilteringUpstreamListener) {
                throw new IAE("FilteringUpstreamListener should not be registered with ServiceDruidNodeDiscovery itself", new Object[0]);
            }
            Object object = this.lock;
            synchronized (object) {
                if (!this.unmodifiableNodes.isEmpty()) {
                    listener.nodesAdded(this.unmodifiableNodes);
                }
                if (this.uninitializedNodeRoles == 0) {
                    listener.nodeViewInitialized();
                }
                this.listeners.add(listener);
            }
        }

        DruidNodeDiscovery.Listener filteringUpstreamListener() {
            return new FilteringUpstreamListener();
        }

        class FilteringUpstreamListener
        implements DruidNodeDiscovery.Listener {
            FilteringUpstreamListener() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void nodesAdded(Collection<DiscoveryDruidNode> nodesDiscovered) {
                Object object = ServiceDruidNodeDiscovery.this.lock;
                synchronized (object) {
                    ArrayList<DiscoveryDruidNode> nodesAdded = new ArrayList<DiscoveryDruidNode>();
                    for (DiscoveryDruidNode node : nodesDiscovered) {
                        if (node.getServices().containsKey(ServiceDruidNodeDiscovery.this.service)) {
                            DiscoveryDruidNode prev = ServiceDruidNodeDiscovery.this.nodes.putIfAbsent(node.getDruidNode().getHostAndPortToUse(), node);
                            if (prev == null) {
                                nodesAdded.add(node);
                                continue;
                            }
                            log.warn("Node[%s] discovered but already exists [%s].", node, prev);
                            continue;
                        }
                        log.warn("Node[%s] discovered but doesn't have service[%s]. Ignored.", node, ServiceDruidNodeDiscovery.this.service);
                    }
                    if (nodesAdded.isEmpty()) {
                        return;
                    }
                    Collection<DiscoveryDruidNode> unmodifiableNodesAdded = Collections.unmodifiableCollection(nodesAdded);
                    for (DruidNodeDiscovery.Listener listener : ServiceDruidNodeDiscovery.this.listeners) {
                        try {
                            listener.nodesAdded(unmodifiableNodesAdded);
                        }
                        catch (Exception ex) {
                            log.error(ex, "Listener[%s].nodesAdded(%s) threw exception. Ignored.", listener, nodesAdded);
                        }
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void nodesRemoved(Collection<DiscoveryDruidNode> nodesDisappeared) {
                Object object = ServiceDruidNodeDiscovery.this.lock;
                synchronized (object) {
                    ArrayList<DiscoveryDruidNode> nodesRemoved = new ArrayList<DiscoveryDruidNode>();
                    for (DiscoveryDruidNode node : nodesDisappeared) {
                        DiscoveryDruidNode prev = (DiscoveryDruidNode)ServiceDruidNodeDiscovery.this.nodes.remove(node.getDruidNode().getHostAndPortToUse());
                        if (prev != null) {
                            nodesRemoved.add(node);
                            continue;
                        }
                        log.warn("Node[%s] disappeared but was unknown for service listener [%s].", node, ServiceDruidNodeDiscovery.this.service);
                    }
                    if (nodesRemoved.isEmpty()) {
                        return;
                    }
                    Collection<DiscoveryDruidNode> unmodifiableNodesRemoved = Collections.unmodifiableCollection(nodesRemoved);
                    for (DruidNodeDiscovery.Listener listener : ServiceDruidNodeDiscovery.this.listeners) {
                        try {
                            listener.nodesRemoved(unmodifiableNodesRemoved);
                        }
                        catch (Exception ex) {
                            log.error(ex, "Listener[%s].nodesRemoved(%s) threw exception. Ignored.", listener, nodesRemoved);
                        }
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void nodeViewInitialized() {
                Object object = ServiceDruidNodeDiscovery.this.lock;
                synchronized (object) {
                    if (ServiceDruidNodeDiscovery.this.uninitializedNodeRoles == 0) {
                        log.error("Unexpected call of nodeViewInitialized()", new Object[0]);
                        return;
                    }
                    ServiceDruidNodeDiscovery.this.uninitializedNodeRoles--;
                    if (ServiceDruidNodeDiscovery.this.uninitializedNodeRoles == 0) {
                        for (DruidNodeDiscovery.Listener listener : ServiceDruidNodeDiscovery.this.listeners) {
                            try {
                                listener.nodeViewInitialized();
                            }
                            catch (Exception ex) {
                                log.error(ex, "Listener[%s].nodeViewInitialized() threw exception. Ignored.", listener);
                            }
                        }
                    }
                }
            }
        }
    }
}

