/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.data.input.impl.prefetch;

import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public class FetchConfig {
    private static final long DEFAULT_MAX_CACHE_CAPACITY_BYTES = 0x40000000L;
    private static final long DEFAULT_MAX_FETCH_CAPACITY_BYTES = 0x40000000L;
    private static final long DEFAULT_FETCH_TIMEOUT_MS = TimeUnit.SECONDS.toMillis(60L);
    private static final int DEFAULT_MAX_FETCH_RETRY = 3;
    private final long maxFetchCapacityBytes;
    private final long maxCacheCapacityBytes;
    private final long prefetchTriggerBytes;
    private final long fetchTimeout;
    private final int maxFetchRetry;

    public FetchConfig(@Nullable Long maxCacheCapacityBytes, @Nullable Long maxFetchCapacityBytes, @Nullable Long prefetchTriggerBytes, @Nullable Long fetchTimeout, @Nullable Integer maxFetchRetry) {
        this.maxCacheCapacityBytes = maxCacheCapacityBytes == null ? 0x40000000L : maxCacheCapacityBytes;
        this.maxFetchCapacityBytes = maxFetchCapacityBytes == null ? 0x40000000L : maxFetchCapacityBytes;
        this.prefetchTriggerBytes = prefetchTriggerBytes == null ? this.maxFetchCapacityBytes / 2L : prefetchTriggerBytes;
        this.fetchTimeout = fetchTimeout == null ? DEFAULT_FETCH_TIMEOUT_MS : fetchTimeout;
        this.maxFetchRetry = maxFetchRetry == null ? 3 : maxFetchRetry;
    }

    public long getMaxCacheCapacityBytes() {
        return this.maxCacheCapacityBytes;
    }

    public long getMaxFetchCapacityBytes() {
        return this.maxFetchCapacityBytes;
    }

    public long getPrefetchTriggerBytes() {
        return this.prefetchTriggerBytes;
    }

    public long getFetchTimeout() {
        return this.fetchTimeout;
    }

    public int getMaxFetchRetry() {
        return this.maxFetchRetry;
    }
}

