/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.data.input.impl;

import java.util.Objects;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonSubTypes;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonTypeInfo;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonValue;
import org.apache.hive.druid.com.google.common.base.Strings;
import org.apache.hive.druid.org.apache.druid.data.input.impl.DoubleDimensionSchema;
import org.apache.hive.druid.org.apache.druid.data.input.impl.FloatDimensionSchema;
import org.apache.hive.druid.org.apache.druid.data.input.impl.LongDimensionSchema;
import org.apache.hive.druid.org.apache.druid.data.input.impl.NewSpatialDimensionSchema;
import org.apache.hive.druid.org.apache.druid.data.input.impl.StringDimensionSchema;
import org.apache.hive.druid.org.apache.druid.java.util.common.StringUtils;
import org.apache.hive.druid.org.apache.druid.java.util.emitter.EmittingLogger;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type", defaultImpl=StringDimensionSchema.class)
@JsonSubTypes(value={@JsonSubTypes.Type(name="string", value=StringDimensionSchema.class), @JsonSubTypes.Type(name="long", value=LongDimensionSchema.class), @JsonSubTypes.Type(name="float", value=FloatDimensionSchema.class), @JsonSubTypes.Type(name="double", value=DoubleDimensionSchema.class), @JsonSubTypes.Type(name="spatial", value=NewSpatialDimensionSchema.class)})
public abstract class DimensionSchema {
    public static final String STRING_TYPE_NAME = "string";
    public static final String LONG_TYPE_NAME = "long";
    public static final String FLOAT_TYPE_NAME = "float";
    public static final String SPATIAL_TYPE_NAME = "spatial";
    public static final String DOUBLE_TYPE_NAME = "double";
    private static final EmittingLogger log = new EmittingLogger(DimensionSchema.class);
    private final String name;
    private final MultiValueHandling multiValueHandling;
    private final boolean createBitmapIndex;

    protected DimensionSchema(String name, MultiValueHandling multiValueHandling, boolean createBitmapIndex) {
        if (Strings.isNullOrEmpty(name)) {
            log.warn("Null or Empty Dimension found", new Object[0]);
        }
        this.name = name;
        this.multiValueHandling = multiValueHandling == null ? MultiValueHandling.ofDefault() : multiValueHandling;
        this.createBitmapIndex = createBitmapIndex;
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public MultiValueHandling getMultiValueHandling() {
        return this.multiValueHandling;
    }

    @JsonProperty(value="createBitmapIndex")
    public boolean hasBitmapIndex() {
        return this.createBitmapIndex;
    }

    @JsonIgnore
    public abstract String getTypeName();

    @JsonIgnore
    public abstract ValueType getValueType();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DimensionSchema that = (DimensionSchema)o;
        return this.createBitmapIndex == that.createBitmapIndex && Objects.equals(this.name, that.name) && Objects.equals(this.getTypeName(), that.getTypeName()) && Objects.equals((Object)this.getValueType(), (Object)that.getValueType()) && this.multiValueHandling == that.multiValueHandling;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.multiValueHandling, this.createBitmapIndex, this.getTypeName(), this.getValueType()});
    }

    public String toString() {
        return "DimensionSchema{name='" + this.name + '\'' + ", valueType=" + (Object)((Object)this.getValueType()) + ", typeName=" + this.getTypeName() + ", multiValueHandling=" + (Object)((Object)this.multiValueHandling) + ", createBitmapIndex=" + this.createBitmapIndex + '}';
    }

    public static enum MultiValueHandling {
        SORTED_ARRAY,
        SORTED_SET,
        ARRAY{

            @Override
            public boolean needSorting() {
                return false;
            }
        };


        public boolean needSorting() {
            return true;
        }

        @JsonValue
        public String toString() {
            return StringUtils.toUpperCase(this.name());
        }

        @JsonCreator
        public static MultiValueHandling fromString(String name) {
            return name == null ? MultiValueHandling.ofDefault() : MultiValueHandling.valueOf(StringUtils.toUpperCase(name));
        }

        public static MultiValueHandling ofDefault() {
            return SORTED_ARRAY;
        }
    }

    public static enum ValueType {
        FLOAT,
        LONG,
        STRING,
        DOUBLE,
        COMPLEX;


        @JsonValue
        public String toString() {
            return StringUtils.toUpperCase(this.name());
        }

        @JsonCreator
        public static ValueType fromString(String name) {
            return ValueType.valueOf(StringUtils.toUpperCase(name));
        }
    }
}

