/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.data.input.impl;

import com.opencsv.RFC4180Parser;
import com.opencsv.RFC4180ParserBuilder;
import com.opencsv.enums.CSVReaderNullFieldIndicator;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.org.apache.druid.common.config.NullHandling;
import org.apache.hive.druid.org.apache.druid.data.input.InputEntity;
import org.apache.hive.druid.org.apache.druid.data.input.InputEntityReader;
import org.apache.hive.druid.org.apache.druid.data.input.InputRowSchema;
import org.apache.hive.druid.org.apache.druid.data.input.impl.DelimitedValueReader;
import org.apache.hive.druid.org.apache.druid.data.input.impl.FlatTextInputFormat;

public class CsvInputFormat
extends FlatTextInputFormat {
    private static final char SEPARATOR = ',';
    private static final RFC4180Parser PARSER = CsvInputFormat.createOpenCsvParser();

    @JsonCreator
    public CsvInputFormat(@JsonProperty(value="columns") @Nullable List<String> columns, @JsonProperty(value="listDelimiter") @Nullable String listDelimiter, @Deprecated @JsonProperty(value="hasHeaderRow") @Nullable Boolean hasHeaderRow, @JsonProperty(value="findColumnsFromHeader") @Nullable Boolean findColumnsFromHeader, @JsonProperty(value="skipHeaderRows") int skipHeaderRows) {
        super(columns, listDelimiter, String.valueOf(','), hasHeaderRow, findColumnsFromHeader, skipHeaderRows);
    }

    @Override
    @JsonIgnore
    public String getDelimiter() {
        return super.getDelimiter();
    }

    @Override
    public boolean isSplittable() {
        return true;
    }

    @Override
    public InputEntityReader createReader(InputRowSchema inputRowSchema, InputEntity source, File temporaryDirectory) {
        return new DelimitedValueReader(inputRowSchema, source, this.getListDelimiter(), this.getColumns(), this.isFindColumnsFromHeader(), this.getSkipHeaderRows(), line -> Arrays.asList(PARSER.parseLine(line)));
    }

    public static RFC4180Parser createOpenCsvParser() {
        return NullHandling.replaceWithDefault() ? new RFC4180ParserBuilder().withSeparator(',').build() : new RFC4180ParserBuilder().withFieldAsNull(CSVReaderNullFieldIndicator.EMPTY_SEPARATORS).withSeparator(',').build();
    }
}

