/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.data.input;

import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableSortedSet;
import org.apache.hive.druid.com.google.common.primitives.Longs;
import org.apache.hive.druid.org.apache.druid.common.config.NullHandling;
import org.apache.hive.druid.org.apache.druid.data.input.InputRow;
import org.apache.hive.druid.org.apache.druid.java.util.common.StringUtils;
import org.apache.hive.druid.org.apache.druid.java.util.common.parsers.ParseException;

public final class Rows {
    public static List<Object> toGroupKey(long timeStamp, InputRow inputRow) {
        TreeMap<String, ImmutableSortedSet<String>> dims = new TreeMap<String, ImmutableSortedSet<String>>();
        for (String dim : inputRow.getDimensions()) {
            ImmutableSortedSet<String> dimValues = ImmutableSortedSet.copyOf(inputRow.getDimension(dim));
            if (dimValues.size() <= 0) continue;
            dims.put(dim, dimValues);
        }
        return ImmutableList.of(Long.valueOf(timeStamp), dims);
    }

    public static List<String> objectToStrings(Object inputValue) {
        if (inputValue == null) {
            return Collections.emptyList();
        }
        if (inputValue instanceof List) {
            return ((List)inputValue).stream().map(String::valueOf).collect(Collectors.toList());
        }
        if (inputValue instanceof byte[]) {
            return Collections.singletonList(StringUtils.encodeBase64String((byte[])inputValue));
        }
        return Collections.singletonList(String.valueOf(inputValue));
    }

    @Nullable
    public static Number objectToNumber(String name, Object inputValue) {
        if (inputValue == null) {
            return NullHandling.defaultLongValue();
        }
        if (inputValue instanceof Number) {
            return (Number)inputValue;
        }
        if (inputValue instanceof String) {
            try {
                String metricValueString = StringUtils.removeChar(((String)inputValue).trim(), ',');
                metricValueString = Rows.trimLeadingPlusOfLongString(metricValueString);
                Long v = Longs.tryParse(metricValueString);
                if (v != null) {
                    return v;
                }
                return Double.valueOf(metricValueString);
            }
            catch (Exception e) {
                throw new ParseException(e, "Unable to parse value[%s] for field[%s]", inputValue, name);
            }
        }
        throw new ParseException("Unknown type[%s] for field[%s]", inputValue.getClass(), name);
    }

    private static String trimLeadingPlusOfLongString(String metricValueString) {
        char secondChar;
        if (metricValueString.length() > 1 && metricValueString.charAt(0) == '+' && (secondChar = metricValueString.charAt(1)) >= '0' && secondChar <= '9') {
            metricValueString = metricValueString.substring(1);
        }
        return metricValueString;
    }

    private Rows() {
    }
}

