/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.data.input;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.hive.druid.org.apache.druid.data.input.InputEntityReader;
import org.apache.hive.druid.org.apache.druid.data.input.InputRow;
import org.apache.hive.druid.org.apache.druid.data.input.InputRowListPlusRawValues;
import org.apache.hive.druid.org.apache.druid.java.util.common.parsers.CloseableIterator;
import org.apache.hive.druid.org.apache.druid.java.util.common.parsers.ParseException;

public abstract class IntermediateRowParsingReader<T>
implements InputEntityReader {
    @Override
    public CloseableIterator<InputRow> read() throws IOException {
        final CloseableIterator<T> intermediateRowIterator = this.intermediateRowIterator();
        return new CloseableIterator<InputRow>(){
            Iterator<InputRow> rows = null;

            @Override
            public boolean hasNext() {
                if (this.rows == null || !this.rows.hasNext()) {
                    if (!intermediateRowIterator.hasNext()) {
                        return false;
                    }
                    Object row = intermediateRowIterator.next();
                    try {
                        this.rows = IntermediateRowParsingReader.this.parseInputRows(row).iterator();
                    }
                    catch (IOException e) {
                        this.rows = new ExceptionThrowingIterator(new ParseException(e, "Unable to parse row [%s]", row));
                    }
                    catch (ParseException e) {
                        this.rows = new ExceptionThrowingIterator(e);
                    }
                }
                return true;
            }

            @Override
            public InputRow next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return this.rows.next();
            }

            @Override
            public void close() throws IOException {
                intermediateRowIterator.close();
            }
        };
    }

    @Override
    public CloseableIterator<InputRowListPlusRawValues> sample() throws IOException {
        return this.intermediateRowIterator().map(row -> {
            Map<String, Object> rawColumns;
            try {
                rawColumns = this.toMap(row);
            }
            catch (Exception e) {
                return InputRowListPlusRawValues.of(null, new ParseException(e, "Unable to parse row [%s] into JSON", row));
            }
            try {
                return InputRowListPlusRawValues.of(this.parseInputRows(row), rawColumns);
            }
            catch (ParseException e) {
                return InputRowListPlusRawValues.of(rawColumns, e);
            }
            catch (IOException e) {
                return InputRowListPlusRawValues.of(rawColumns, new ParseException(e, "Unable to parse row [%s] into inputRow", row));
            }
        });
    }

    protected abstract CloseableIterator<T> intermediateRowIterator() throws IOException;

    protected abstract List<InputRow> parseInputRows(T var1) throws IOException, ParseException;

    protected abstract Map<String, Object> toMap(T var1) throws IOException;

    private static class ExceptionThrowingIterator
    implements CloseableIterator<InputRow> {
        private final Exception exception;
        private boolean thrown = false;

        private ExceptionThrowingIterator(Exception exception) {
            this.exception = exception;
        }

        @Override
        public boolean hasNext() {
            return !this.thrown;
        }

        @Override
        public InputRow next() {
            this.thrown = true;
            if (this.exception instanceof RuntimeException) {
                throw (RuntimeException)this.exception;
            }
            throw new RuntimeException(this.exception);
        }

        @Override
        public void close() throws IOException {
        }
    }
}

