/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.curator.discovery;

import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.function.Function;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.utils.CloseableExecutorService;
import org.apache.curator.utils.ZKPaths;
import org.apache.curator.x.discovery.DownInstancePolicy;
import org.apache.curator.x.discovery.InstanceFilter;
import org.apache.curator.x.discovery.ProviderStrategy;
import org.apache.curator.x.discovery.ServiceCache;
import org.apache.curator.x.discovery.ServiceCacheBuilder;
import org.apache.curator.x.discovery.ServiceDiscovery;
import org.apache.curator.x.discovery.ServiceDiscoveryBuilder;
import org.apache.curator.x.discovery.ServiceInstance;
import org.apache.curator.x.discovery.ServiceProvider;
import org.apache.curator.x.discovery.ServiceProviderBuilder;
import org.apache.curator.x.discovery.details.ServiceCacheListener;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.org.apache.druid.client.coordinator.Coordinator;
import org.apache.hive.druid.org.apache.druid.client.indexing.IndexingService;
import org.apache.hive.druid.org.apache.druid.curator.discovery.CuratorDruidLeaderSelector;
import org.apache.hive.druid.org.apache.druid.curator.discovery.CuratorDruidNodeAnnouncer;
import org.apache.hive.druid.org.apache.druid.curator.discovery.CuratorDruidNodeDiscoveryProvider;
import org.apache.hive.druid.org.apache.druid.curator.discovery.CuratorServiceAnnouncer;
import org.apache.hive.druid.org.apache.druid.curator.discovery.ServerDiscoveryFactory;
import org.apache.hive.druid.org.apache.druid.curator.discovery.ServiceAnnouncer;
import org.apache.hive.druid.org.apache.druid.discovery.DruidLeaderSelector;
import org.apache.hive.druid.org.apache.druid.discovery.DruidNodeAnnouncer;
import org.apache.hive.druid.org.apache.druid.discovery.DruidNodeDiscoveryProvider;
import org.apache.hive.druid.org.apache.druid.guice.DruidBinders;
import org.apache.hive.druid.org.apache.druid.guice.JsonConfigProvider;
import org.apache.hive.druid.org.apache.druid.guice.KeyHolder;
import org.apache.hive.druid.org.apache.druid.guice.LazySingleton;
import org.apache.hive.druid.org.apache.druid.guice.LifecycleModule;
import org.apache.hive.druid.org.apache.druid.guice.PolyBind;
import org.apache.hive.druid.org.apache.druid.guice.annotations.Self;
import org.apache.hive.druid.org.apache.druid.java.util.common.lifecycle.Lifecycle;
import org.apache.hive.druid.org.apache.druid.server.DruidNode;
import org.apache.hive.druid.org.apache.druid.server.initialization.CuratorDiscoveryConfig;
import org.apache.hive.druid.org.apache.druid.server.initialization.ZkPathsConfig;

public class DiscoveryModule
implements Module {
    private static final String NAME = "DiscoveryModule:internal";
    private static final String INTERNAL_DISCOVERY_PROP = "druid.discovery.type";
    private static final String CURATOR_KEY = "curator";

    public static void registerDefault(Binder binder) {
        DiscoveryModule.registerKey(binder, (Key<DruidNode>)Key.get((TypeLiteral)new TypeLiteral<DruidNode>(){}));
    }

    public static void register(Binder binder, Annotation annotation) {
        DiscoveryModule.registerKey(binder, (Key<DruidNode>)Key.get((TypeLiteral)new TypeLiteral<DruidNode>(){}, (Annotation)annotation));
    }

    public static void register(Binder binder, Class<? extends Annotation> annotation) {
        DiscoveryModule.registerKey(binder, (Key<DruidNode>)Key.get((TypeLiteral)new TypeLiteral<DruidNode>(){}, annotation));
    }

    public static void registerKey(Binder binder, Key<DruidNode> key) {
        DruidBinders.discoveryAnnouncementBinder(binder).addBinding().toInstance(new KeyHolder<DruidNode>(key));
        LifecycleModule.register(binder, ServiceAnnouncer.class);
    }

    public void configure(Binder binder) {
        JsonConfigProvider.bind(binder, "druid.discovery.curator", CuratorDiscoveryConfig.class);
        binder.bind(CuratorServiceAnnouncer.class).in(LazySingleton.class);
        DruidBinders.discoveryAnnouncementBinder(binder);
        binder.bind(ServiceAnnouncer.class).to(Key.get(CuratorServiceAnnouncer.class, (Annotation)Names.named((String)NAME))).in(LazySingleton.class);
        PolyBind.createChoiceWithDefault(binder, INTERNAL_DISCOVERY_PROP, Key.get(DruidNodeAnnouncer.class), CURATOR_KEY);
        PolyBind.createChoiceWithDefault(binder, INTERNAL_DISCOVERY_PROP, Key.get(DruidNodeDiscoveryProvider.class), CURATOR_KEY);
        PolyBind.createChoiceWithDefault(binder, INTERNAL_DISCOVERY_PROP, Key.get(DruidLeaderSelector.class, Coordinator.class), CURATOR_KEY);
        PolyBind.createChoiceWithDefault(binder, INTERNAL_DISCOVERY_PROP, Key.get(DruidLeaderSelector.class, IndexingService.class), CURATOR_KEY);
        PolyBind.optionBinder(binder, Key.get(DruidNodeDiscoveryProvider.class)).addBinding((Object)CURATOR_KEY).to(CuratorDruidNodeDiscoveryProvider.class).in(LazySingleton.class);
        PolyBind.optionBinder(binder, Key.get(DruidNodeAnnouncer.class)).addBinding((Object)CURATOR_KEY).to(CuratorDruidNodeAnnouncer.class).in(LazySingleton.class);
        PolyBind.optionBinder(binder, Key.get(DruidLeaderSelector.class, Coordinator.class)).addBinding((Object)CURATOR_KEY).toProvider((Provider)new DruidLeaderSelectorProvider(zkPathsConfig -> ZKPaths.makePath((String)zkPathsConfig.getCoordinatorPath(), (String)"_COORDINATOR"))).in(LazySingleton.class);
        PolyBind.optionBinder(binder, Key.get(DruidLeaderSelector.class, IndexingService.class)).addBinding((Object)CURATOR_KEY).toProvider((Provider)new DruidLeaderSelectorProvider(zkPathsConfig -> ZKPaths.makePath((String)zkPathsConfig.getOverlordPath(), (String)"_OVERLORD"))).in(LazySingleton.class);
    }

    @Provides
    @LazySingleton
    @Named(value="DiscoveryModule:internal")
    public CuratorServiceAnnouncer getServiceAnnouncer(final CuratorServiceAnnouncer announcer, final Injector injector, final Set<KeyHolder<DruidNode>> nodesToAnnounce, Lifecycle lifecycle) throws Exception {
        lifecycle.addMaybeStartHandler(new Lifecycle.Handler(){
            private volatile List<DruidNode> nodes = null;

            @Override
            public void start() {
                if (this.nodes == null) {
                    this.nodes = new ArrayList<DruidNode>();
                    for (KeyHolder holder : nodesToAnnounce) {
                        this.nodes.add((DruidNode)injector.getInstance(holder.getKey()));
                    }
                }
                for (DruidNode node : this.nodes) {
                    announcer.announce(node);
                }
            }

            @Override
            public void stop() {
                if (this.nodes != null) {
                    for (DruidNode node : this.nodes) {
                        announcer.unannounce(node);
                    }
                }
            }
        }, Lifecycle.Stage.ANNOUNCEMENTS);
        return announcer;
    }

    @Provides
    @LazySingleton
    public ServiceDiscovery<Void> getServiceDiscovery(CuratorFramework curator, CuratorDiscoveryConfig config, Lifecycle lifecycle) throws Exception {
        if (!config.useDiscovery()) {
            return new NoopServiceDiscovery<Void>();
        }
        final ServiceDiscovery serviceDiscovery = ServiceDiscoveryBuilder.builder(Void.class).basePath(config.getPath()).client(curator).build();
        lifecycle.addMaybeStartHandler(new Lifecycle.Handler(){

            @Override
            public void start() throws Exception {
                serviceDiscovery.start();
            }

            @Override
            public void stop() {
                try {
                    serviceDiscovery.close();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
        return serviceDiscovery;
    }

    @Provides
    @LazySingleton
    public ServerDiscoveryFactory getServerDiscoveryFactory(ServiceDiscovery<Void> serviceDiscovery) {
        return new ServerDiscoveryFactory(serviceDiscovery);
    }

    private static class DruidLeaderSelectorProvider
    implements Provider<DruidLeaderSelector> {
        @Inject
        private CuratorFramework curatorFramework;
        @Inject
        @Self
        private DruidNode druidNode;
        @Inject
        private ZkPathsConfig zkPathsConfig;
        private final Function<ZkPathsConfig, String> latchPathFn;

        DruidLeaderSelectorProvider(Function<ZkPathsConfig, String> latchPathFn) {
            this.latchPathFn = latchPathFn;
        }

        public DruidLeaderSelector get() {
            return new CuratorDruidLeaderSelector(this.curatorFramework, this.druidNode, this.latchPathFn.apply(this.zkPathsConfig));
        }
    }

    private static class NoopServiceProvider<T>
    implements ServiceProvider<T> {
        private NoopServiceProvider() {
        }

        public void start() {
        }

        public ServiceInstance<T> getInstance() {
            return null;
        }

        public Collection<ServiceInstance<T>> getAllInstances() {
            return Collections.emptyList();
        }

        public void noteError(ServiceInstance<T> tServiceInstance) {
        }

        public void close() {
        }
    }

    private static class NoopServiceProviderBuilder<T>
    implements ServiceProviderBuilder<T> {
        private NoopServiceProviderBuilder() {
        }

        public ServiceProvider<T> build() {
            return new NoopServiceProvider();
        }

        public ServiceProviderBuilder<T> serviceName(String serviceName) {
            return this;
        }

        public ServiceProviderBuilder<T> providerStrategy(ProviderStrategy<T> providerStrategy) {
            return this;
        }

        public ServiceProviderBuilder<T> threadFactory(ThreadFactory threadFactory) {
            return this;
        }

        public ServiceProviderBuilder<T> downInstancePolicy(DownInstancePolicy downInstancePolicy) {
            return this;
        }

        public ServiceProviderBuilder<T> additionalFilter(InstanceFilter<T> tInstanceFilter) {
            return this;
        }
    }

    private static class NoopServiceCacheBuilder<T>
    implements ServiceCacheBuilder<T> {
        private NoopServiceCacheBuilder() {
        }

        public ServiceCache<T> build() {
            return new NoopServiceCache();
        }

        public ServiceCacheBuilder<T> name(String name) {
            return this;
        }

        public ServiceCacheBuilder<T> threadFactory(ThreadFactory threadFactory) {
            return this;
        }

        public ServiceCacheBuilder<T> executorService(ExecutorService executorService) {
            return this;
        }

        public ServiceCacheBuilder<T> executorService(CloseableExecutorService closeableExecutorService) {
            return this;
        }

        private static class NoopServiceCache<T>
        implements ServiceCache<T> {
            private NoopServiceCache() {
            }

            public List<ServiceInstance<T>> getInstances() {
                return ImmutableList.of();
            }

            public void start() {
            }

            public void close() {
            }

            public void addListener(ServiceCacheListener listener) {
            }

            public void addListener(ServiceCacheListener listener, Executor executor) {
            }

            public void removeListener(ServiceCacheListener listener) {
            }
        }
    }

    private static class NoopServiceDiscovery<T>
    implements ServiceDiscovery<T> {
        private NoopServiceDiscovery() {
        }

        public void start() {
        }

        public void registerService(ServiceInstance<T> service) {
        }

        public void updateService(ServiceInstance<T> service) {
        }

        public void unregisterService(ServiceInstance<T> service) {
        }

        public ServiceCacheBuilder<T> serviceCacheBuilder() {
            return new NoopServiceCacheBuilder();
        }

        public Collection<String> queryForNames() {
            return ImmutableList.of();
        }

        public Collection<ServiceInstance<T>> queryForInstances(String name) {
            return ImmutableList.of();
        }

        public ServiceInstance<T> queryForInstance(String name, String id) {
            return null;
        }

        public ServiceProviderBuilder<T> serviceProviderBuilder() {
            return new NoopServiceProviderBuilder();
        }

        public void close() {
        }
    }
}

