/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.curator.discovery;

import java.io.Closeable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.leader.LeaderLatch;
import org.apache.curator.framework.recipes.leader.LeaderLatchListener;
import org.apache.curator.framework.recipes.leader.Participant;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.org.apache.druid.concurrent.LifecycleLock;
import org.apache.hive.druid.org.apache.druid.discovery.DruidLeaderSelector;
import org.apache.hive.druid.org.apache.druid.guice.annotations.Self;
import org.apache.hive.druid.org.apache.druid.java.util.common.ISE;
import org.apache.hive.druid.org.apache.druid.java.util.common.StringUtils;
import org.apache.hive.druid.org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.CloseQuietly;
import org.apache.hive.druid.org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.hive.druid.org.apache.druid.server.DruidNode;

public class CuratorDruidLeaderSelector
implements DruidLeaderSelector {
    private static final EmittingLogger log = new EmittingLogger(CuratorDruidLeaderSelector.class);
    private final LifecycleLock lifecycleLock = new LifecycleLock();
    private final DruidNode self;
    private final CuratorFramework curator;
    private final String latchPath;
    private ExecutorService listenerExecutor;
    private DruidLeaderSelector.Listener listener = null;
    private final AtomicReference<LeaderLatch> leaderLatch = new AtomicReference();
    private volatile boolean leader = false;
    private volatile int term = 0;

    public CuratorDruidLeaderSelector(CuratorFramework curator, @Self DruidNode self, String latchPath) {
        this.curator = curator;
        this.self = self;
        this.latchPath = latchPath;
        this.leaderLatch.set(this.createNewLeaderLatch());
    }

    private LeaderLatch createNewLeaderLatch() {
        return new LeaderLatch(this.curator, this.latchPath, this.self.getServiceScheme() + "://" + this.self.getHostAndPortToUse());
    }

    private LeaderLatch createNewLeaderLatchWithListener() {
        LeaderLatch newLeaderLatch = this.createNewLeaderLatch();
        newLeaderLatch.addListener(new LeaderLatchListener(){

            public void isLeader() {
                try {
                    if (CuratorDruidLeaderSelector.this.leader) {
                        log.warn("I'm being asked to become leader. But I am already the leader. Ignored event.", new Object[0]);
                        return;
                    }
                    CuratorDruidLeaderSelector.this.leader = true;
                    CuratorDruidLeaderSelector.this.term++;
                    CuratorDruidLeaderSelector.this.listener.becomeLeader();
                }
                catch (Exception ex) {
                    log.makeAlert(ex, "listener becomeLeader() failed. Unable to become leader", new Object[0]).emit();
                    LeaderLatch oldLatch = CuratorDruidLeaderSelector.this.createNewLeaderLatchWithListener();
                    CloseQuietly.close((Closeable)oldLatch);
                    CuratorDruidLeaderSelector.this.leader = false;
                    try {
                        Thread.sleep(ThreadLocalRandom.current().nextInt(1000, 5000));
                        ((LeaderLatch)CuratorDruidLeaderSelector.this.leaderLatch.get()).start();
                    }
                    catch (Exception e) {
                        log.makeAlert(e, "I am a zombie", new Object[0]).emit();
                    }
                }
            }

            public void notLeader() {
                try {
                    if (!CuratorDruidLeaderSelector.this.leader) {
                        log.warn("I'm being asked to stop being leader. But I am not the leader. Ignored event.", new Object[0]);
                        return;
                    }
                    CuratorDruidLeaderSelector.this.leader = false;
                    CuratorDruidLeaderSelector.this.listener.stopBeingLeader();
                }
                catch (Exception ex) {
                    log.makeAlert(ex, "listener.stopBeingLeader() failed. Unable to stopBeingLeader", new Object[0]).emit();
                }
            }
        }, (Executor)this.listenerExecutor);
        return this.leaderLatch.getAndSet(newLeaderLatch);
    }

    @Override
    @Nullable
    public String getCurrentLeader() {
        try {
            LeaderLatch latch = this.leaderLatch.get();
            Participant participant = latch.getLeader();
            if (participant.isLeader()) {
                return participant.getId();
            }
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isLeader() {
        return this.leader;
    }

    @Override
    public int localTerm() {
        return this.term;
    }

    @Override
    public void registerListener(DruidLeaderSelector.Listener listener) {
        Preconditions.checkArgument(listener != null, "listener is null.");
        if (!this.lifecycleLock.canStart()) {
            throw new ISE("can't start.", new Object[0]);
        }
        try {
            this.listener = listener;
            this.listenerExecutor = Execs.singleThreaded(StringUtils.format("LeaderSelector[%s]", this.latchPath));
            this.createNewLeaderLatchWithListener();
            this.leaderLatch.get().start();
            this.lifecycleLock.started();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            this.lifecycleLock.exitStart();
        }
    }

    @Override
    public void unregisterListener() {
        if (!this.lifecycleLock.canStop()) {
            throw new ISE("can't stop.", new Object[0]);
        }
        CloseQuietly.close((Closeable)this.leaderLatch.get());
        this.listenerExecutor.shutdownNow();
    }
}

