/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.collections.bitmap;

import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.org.roaringbitmap.BatchIterator;
import org.apache.hive.druid.org.roaringbitmap.IntIterator;

public final class BatchIteratorAdapter
implements BatchIterator {
    private final IntIterator iterator;

    public BatchIteratorAdapter(IntIterator iterator) {
        this.iterator = Preconditions.checkNotNull(iterator, "iterator");
    }

    @Override
    public int nextBatch(int[] buffer) {
        int i;
        for (i = 0; i < buffer.length && this.iterator.hasNext(); ++i) {
            buffer[i] = this.iterator.next();
        }
        return i;
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public BatchIterator clone() {
        return new BatchIteratorAdapter(this.iterator.clone());
    }
}

