/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.client.selector;

import it.unimi.dsi.fastutil.ints.Int2ObjectRBTreeMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.apache.hive.druid.org.apache.druid.client.DataSegmentInterner;
import org.apache.hive.druid.org.apache.druid.client.selector.DiscoverySelector;
import org.apache.hive.druid.org.apache.druid.client.selector.QueryableDruidServer;
import org.apache.hive.druid.org.apache.druid.client.selector.TierSelectorStrategy;
import org.apache.hive.druid.org.apache.druid.server.coordination.DruidServerMetadata;
import org.apache.hive.druid.org.apache.druid.server.coordination.ServerType;
import org.apache.hive.druid.org.apache.druid.timeline.DataSegment;
import org.apache.hive.druid.org.apache.druid.timeline.Overshadowable;

public class ServerSelector
implements DiscoverySelector<QueryableDruidServer>,
Overshadowable<ServerSelector> {
    private final Int2ObjectRBTreeMap<Set<QueryableDruidServer>> historicalServers;
    private final Int2ObjectRBTreeMap<Set<QueryableDruidServer>> realtimeServers;
    private final TierSelectorStrategy strategy;
    private final AtomicReference<DataSegment> segment;

    public ServerSelector(DataSegment segment, TierSelectorStrategy strategy) {
        this.segment = new AtomicReference<DataSegment>(DataSegmentInterner.intern(segment));
        this.strategy = strategy;
        this.historicalServers = new Int2ObjectRBTreeMap(strategy.getComparator());
        this.realtimeServers = new Int2ObjectRBTreeMap(strategy.getComparator());
    }

    public DataSegment getSegment() {
        return this.segment.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addServerAndUpdateSegment(QueryableDruidServer server, DataSegment segment) {
        ServerSelector serverSelector = this;
        synchronized (serverSelector) {
            this.segment.set(segment);
            Set priorityServers = server.getServer().getType() == ServerType.HISTORICAL ? this.historicalServers.computeIfAbsent(server.getServer().getPriority(), p -> new HashSet()) : this.realtimeServers.computeIfAbsent(server.getServer().getPriority(), p -> new HashSet());
            priorityServers.add(server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeServer(QueryableDruidServer server) {
        ServerSelector serverSelector = this;
        synchronized (serverSelector) {
            Set<QueryableDruidServer> priorityServers;
            Int2ObjectRBTreeMap<Set<QueryableDruidServer>> servers;
            int priority = server.getServer().getPriority();
            if (server.getServer().getType() == ServerType.HISTORICAL) {
                servers = this.historicalServers;
                priorityServers = this.historicalServers.get(priority);
            } else {
                servers = this.realtimeServers;
                priorityServers = this.realtimeServers.get(priority);
            }
            if (priorityServers == null) {
                return false;
            }
            boolean result = priorityServers.remove(server);
            if (priorityServers.isEmpty()) {
                servers.remove(priority);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        ServerSelector serverSelector = this;
        synchronized (serverSelector) {
            return this.historicalServers.isEmpty() && this.realtimeServers.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DruidServerMetadata> getCandidates(int numCandidates) {
        ServerSelector serverSelector = this;
        synchronized (serverSelector) {
            if (numCandidates > 0) {
                ArrayList<DruidServerMetadata> candidates = new ArrayList<DruidServerMetadata>(numCandidates);
                this.strategy.pick(this.historicalServers, this.segment.get(), numCandidates).stream().map(server -> server.getServer().getMetadata()).forEach(candidates::add);
                if (candidates.size() < numCandidates) {
                    this.strategy.pick(this.realtimeServers, this.segment.get(), numCandidates - candidates.size()).stream().map(server -> server.getServer().getMetadata()).forEach(candidates::add);
                }
                return candidates;
            }
            return this.getAllServers();
        }
    }

    public List<DruidServerMetadata> getAllServers() {
        ArrayList<DruidServerMetadata> servers = new ArrayList<DruidServerMetadata>();
        this.historicalServers.values().stream().flatMap(Collection::stream).map(server -> server.getServer().getMetadata()).forEach(servers::add);
        this.realtimeServers.values().stream().flatMap(Collection::stream).map(server -> server.getServer().getMetadata()).forEach(servers::add);
        return servers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public QueryableDruidServer pick() {
        ServerSelector serverSelector = this;
        synchronized (serverSelector) {
            if (!this.historicalServers.isEmpty()) {
                return this.strategy.pick(this.historicalServers, this.segment.get());
            }
            return this.strategy.pick(this.realtimeServers, this.segment.get());
        }
    }

    @Override
    public boolean overshadows(ServerSelector other) {
        DataSegment thisSegment = this.segment.get();
        DataSegment thatSegment = other.getSegment();
        return thisSegment.overshadows(thatSegment);
    }

    @Override
    public int getStartRootPartitionId() {
        return this.segment.get().getStartRootPartitionId();
    }

    @Override
    public int getEndRootPartitionId() {
        return this.segment.get().getEndRootPartitionId();
    }

    @Override
    public String getVersion() {
        return this.segment.get().getVersion();
    }

    @Override
    public short getMinorVersion() {
        return this.segment.get().getMinorVersion();
    }

    @Override
    public short getAtomicUpdateGroupSize() {
        return this.segment.get().getAtomicUpdateGroupSize();
    }
}

