/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.client.cache;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.function.Function;
import org.apache.commons.lang.mutable.MutableBoolean;
import org.apache.hive.druid.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.org.apache.druid.client.cache.Cache;
import org.apache.hive.druid.org.apache.druid.client.cache.CachePopulator;
import org.apache.hive.druid.org.apache.druid.client.cache.CachePopulatorStats;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.Sequence;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.SequenceWrapper;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.Sequences;
import org.apache.hive.druid.org.apache.druid.java.util.common.logger.Logger;

public class ForegroundCachePopulator
implements CachePopulator {
    private static final Logger log = new Logger(ForegroundCachePopulator.class);
    private final ObjectMapper objectMapper;
    private final CachePopulatorStats cachePopulatorStats;
    private final long maxEntrySize;

    public ForegroundCachePopulator(ObjectMapper objectMapper, CachePopulatorStats cachePopulatorStats, long maxEntrySize) {
        this.objectMapper = Preconditions.checkNotNull(objectMapper, "objectMapper");
        this.cachePopulatorStats = Preconditions.checkNotNull(cachePopulatorStats, "cachePopulatorStats");
        this.maxEntrySize = maxEntrySize;
    }

    @Override
    public <T, CacheType> Sequence<T> wrap(Sequence<T> sequence, Function<T, CacheType> cacheFn, final Cache cache, final Cache.NamedKey cacheKey) {
        JsonGenerator jsonGenerator;
        final ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        final MutableBoolean tooBig = new MutableBoolean(false);
        try {
            jsonGenerator = this.objectMapper.getFactory().createGenerator(bytes);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return Sequences.wrap(Sequences.map(sequence, input -> {
            if (!tooBig.isTrue()) {
                try {
                    jsonGenerator.writeObject(cacheFn.apply(input));
                    if (this.maxEntrySize > 0L && (long)bytes.size() > this.maxEntrySize) {
                        tooBig.setValue(true);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            return input;
        }), new SequenceWrapper(){

            @Override
            public void after(boolean isDone, Throwable thrown) throws Exception {
                jsonGenerator.close();
                if (isDone) {
                    if (tooBig.isTrue() || ForegroundCachePopulator.this.maxEntrySize > 0L && (long)bytes.size() > ForegroundCachePopulator.this.maxEntrySize) {
                        ForegroundCachePopulator.this.cachePopulatorStats.incrementOversized();
                        return;
                    }
                    try {
                        cache.put(cacheKey, bytes.toByteArray());
                        ForegroundCachePopulator.this.cachePopulatorStats.incrementOk();
                    }
                    catch (Exception e) {
                        log.warn(e, "Unable to write to cache", new Object[0]);
                        ForegroundCachePopulator.this.cachePopulatorStats.incrementError();
                    }
                }
            }
        });
    }
}

