/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.client.cache;

import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.org.apache.druid.java.util.common.StringUtils;
import org.apache.hive.druid.org.apache.druid.java.util.common.concurrent.Execs;

public enum CacheExecutorFactory {
    COMMON_FJP{

        @Override
        public Executor createExecutor() {
            return ForkJoinPool.commonPool();
        }
    }
    ,
    SINGLE_THREAD{

        @Override
        public Executor createExecutor() {
            return Execs.singleThreaded("CaffeineWorker-%s");
        }
    }
    ,
    SAME_THREAD{

        @Override
        public Executor createExecutor() {
            return Runnable::run;
        }
    };


    public abstract Executor createExecutor();

    @JsonCreator
    public static CacheExecutorFactory from(String str) {
        return Enum.valueOf(CacheExecutorFactory.class, StringUtils.toUpperCase(str));
    }
}

