/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.client;

import java.util.Set;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.collect.ImmutableSet;
import org.apache.hive.druid.org.apache.druid.server.coordination.DruidServerMetadata;
import org.apache.hive.druid.org.apache.druid.timeline.DataSegment;

public class ImmutableSegmentLoadInfo {
    private final DataSegment segment;
    private final ImmutableSet<DruidServerMetadata> servers;

    @JsonCreator
    public ImmutableSegmentLoadInfo(@JsonProperty(value="segment") DataSegment segment, @JsonProperty(value="servers") Set<DruidServerMetadata> servers) {
        Preconditions.checkNotNull(segment, "segment");
        Preconditions.checkNotNull(servers, "servers");
        this.segment = segment;
        this.servers = ImmutableSet.copyOf(servers);
    }

    @JsonProperty(value="segment")
    public DataSegment getSegment() {
        return this.segment;
    }

    @JsonProperty(value="servers")
    public ImmutableSet<DruidServerMetadata> getServers() {
        return this.servers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableSegmentLoadInfo that = (ImmutableSegmentLoadInfo)o;
        if (!this.segment.equals(that.segment)) {
            return false;
        }
        return this.servers.equals(that.servers);
    }

    public int hashCode() {
        int result = this.segment.hashCode();
        result = 31 * result + this.servers.hashCode();
        return result;
    }

    public String toString() {
        return "SegmentLoadInfo{segment=" + this.segment + ", servers=" + this.servers + '}';
    }
}

