/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.client;

import com.google.inject.Inject;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import org.apache.curator.framework.CuratorFramework;
import org.apache.hive.druid.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.base.Predicate;
import org.apache.hive.druid.com.google.common.base.Predicates;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.com.google.common.collect.Sets;
import org.apache.hive.druid.org.apache.druid.client.AbstractCuratorServerInventoryView;
import org.apache.hive.druid.org.apache.druid.client.DruidServer;
import org.apache.hive.druid.org.apache.druid.client.FilteredServerInventoryView;
import org.apache.hive.druid.org.apache.druid.client.ServerView;
import org.apache.hive.druid.org.apache.druid.client.SingleServerInventoryView;
import org.apache.hive.druid.org.apache.druid.guice.ManageLifecycle;
import org.apache.hive.druid.org.apache.druid.java.util.common.ISE;
import org.apache.hive.druid.org.apache.druid.java.util.common.Pair;
import org.apache.hive.druid.org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.hive.druid.org.apache.druid.server.coordination.DruidServerMetadata;
import org.apache.hive.druid.org.apache.druid.server.initialization.ZkPathsConfig;
import org.apache.hive.druid.org.apache.druid.timeline.DataSegment;

@Deprecated
@ManageLifecycle
public class BatchServerInventoryView
extends AbstractCuratorServerInventoryView<Set<DataSegment>>
implements FilteredServerInventoryView {
    private static final EmittingLogger log = new EmittingLogger(BatchServerInventoryView.class);
    private final ConcurrentMap<String, Set<DataSegment>> zNodes = new ConcurrentHashMap<String, Set<DataSegment>>();
    private final ConcurrentMap<ServerView.SegmentCallback, Predicate<Pair<DruidServerMetadata, DataSegment>>> segmentPredicates = new ConcurrentHashMap<ServerView.SegmentCallback, Predicate<Pair<DruidServerMetadata, DataSegment>>>();
    private final Predicate<Pair<DruidServerMetadata, DataSegment>> defaultFilter;

    @Inject
    public BatchServerInventoryView(ZkPathsConfig zkPaths, CuratorFramework curator, ObjectMapper jsonMapper, Predicate<Pair<DruidServerMetadata, DataSegment>> defaultFilter) {
        super(log, zkPaths.getAnnouncementsPath(), zkPaths.getLiveSegmentsPath(), curator, jsonMapper, new TypeReference<Set<DataSegment>>(){});
        this.defaultFilter = Preconditions.checkNotNull(defaultFilter);
    }

    @Override
    protected DruidServer addInnerInventory(DruidServer container, String inventoryKey, Set<DataSegment> inventory) {
        Set<DataSegment> filteredInventory = this.filterInventory(container, inventory);
        this.zNodes.put(inventoryKey, filteredInventory);
        for (DataSegment segment : filteredInventory) {
            this.addSingleInventory(container, segment);
        }
        return container;
    }

    private Set<DataSegment> filterInventory(final DruidServer container, Set<DataSegment> inventory) {
        Predicate<Pair<DruidServerMetadata, DataSegment>> predicate = Predicates.or(this.defaultFilter, Predicates.or(this.segmentPredicates.values()));
        HashSet<DataSegment> filteredInventory = Sets.newHashSet(Iterables.transform(Iterables.filter(Iterables.transform(inventory, new Function<DataSegment, Pair<DruidServerMetadata, DataSegment>>(){

            @Override
            public Pair<DruidServerMetadata, DataSegment> apply(DataSegment input) {
                return Pair.of(container.getMetadata(), input);
            }
        }), predicate), new Function<Pair<DruidServerMetadata, DataSegment>, DataSegment>(){

            @Override
            public DataSegment apply(Pair<DruidServerMetadata, DataSegment> input) {
                return (DataSegment)input.rhs;
            }
        }));
        return filteredInventory;
    }

    @Override
    protected DruidServer updateInnerInventory(DruidServer container, String inventoryKey, Set<DataSegment> inventory) {
        Set<DataSegment> filteredInventory = this.filterInventory(container, inventory);
        Set existing = (Set)this.zNodes.get(inventoryKey);
        if (existing == null) {
            throw new ISE("Trying to update an inventoryKey[%s] that didn't exist?!", inventoryKey);
        }
        for (DataSegment segment : Sets.difference(filteredInventory, existing)) {
            this.addSingleInventory(container, segment);
        }
        for (DataSegment segment : Sets.difference(existing, filteredInventory)) {
            this.removeSingleInventory(container, segment.getId());
        }
        this.zNodes.put(inventoryKey, filteredInventory);
        return container;
    }

    @Override
    protected DruidServer removeInnerInventory(DruidServer container, String inventoryKey) {
        log.debug("Server[%s] removed container[%s]", container.getName(), inventoryKey);
        Set segments = (Set)this.zNodes.remove(inventoryKey);
        if (segments == null) {
            log.warn("Told to remove container[%s], which didn't exist", inventoryKey);
            return container;
        }
        for (DataSegment segment : segments) {
            this.removeSingleInventory(container, segment.getId());
        }
        return container;
    }

    @Override
    public void registerSegmentCallback(Executor exec, ServerView.SegmentCallback callback, Predicate<Pair<DruidServerMetadata, DataSegment>> filter) {
        SingleServerInventoryView.FilteringSegmentCallback filteringCallback = new SingleServerInventoryView.FilteringSegmentCallback(callback, filter);
        this.segmentPredicates.put(filteringCallback, filter);
        this.registerSegmentCallback(exec, filteringCallback);
    }

    @Override
    protected void segmentCallbackRemoved(ServerView.SegmentCallback callback) {
        this.segmentPredicates.remove(callback);
    }
}

