/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.client;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.curator.framework.CuratorFramework;
import org.apache.hive.druid.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.org.apache.druid.client.DruidServer;
import org.apache.hive.druid.org.apache.druid.client.ServerInventoryView;
import org.apache.hive.druid.org.apache.druid.client.ServerView;
import org.apache.hive.druid.org.apache.druid.curator.inventory.CuratorInventoryManager;
import org.apache.hive.druid.org.apache.druid.curator.inventory.CuratorInventoryManagerStrategy;
import org.apache.hive.druid.org.apache.druid.curator.inventory.InventoryManagerConfig;
import org.apache.hive.druid.org.apache.druid.java.util.common.StringUtils;
import org.apache.hive.druid.org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.hive.druid.org.apache.druid.java.util.common.lifecycle.LifecycleStart;
import org.apache.hive.druid.org.apache.druid.java.util.common.lifecycle.LifecycleStop;
import org.apache.hive.druid.org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.hive.druid.org.apache.druid.timeline.DataSegment;
import org.apache.hive.druid.org.apache.druid.timeline.SegmentId;

public abstract class AbstractCuratorServerInventoryView<InventoryType>
implements ServerInventoryView {
    private final EmittingLogger log;
    private final CuratorInventoryManager<DruidServer, InventoryType> inventoryManager;
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final ConcurrentMap<ServerView.ServerRemovedCallback, Executor> serverRemovedCallbacks = new ConcurrentHashMap<ServerView.ServerRemovedCallback, Executor>();
    private final ConcurrentMap<ServerView.SegmentCallback, Executor> segmentCallbacks = new ConcurrentHashMap<ServerView.SegmentCallback, Executor>();

    public AbstractCuratorServerInventoryView(final EmittingLogger log, final String announcementsPath, final String inventoryPath, CuratorFramework curator, final ObjectMapper jsonMapper, final TypeReference<InventoryType> typeReference) {
        this.log = log;
        this.inventoryManager = new CuratorInventoryManager(curator, new InventoryManagerConfig(){

            @Override
            public String getContainerPath() {
                return announcementsPath;
            }

            @Override
            public String getInventoryPath() {
                return inventoryPath;
            }
        }, Execs.singleThreaded("ServerInventoryView-%s"), new CuratorInventoryManagerStrategy<DruidServer, InventoryType>(){

            @Override
            public DruidServer deserializeContainer(byte[] bytes) {
                try {
                    return jsonMapper.readValue(bytes, DruidServer.class);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public InventoryType deserializeInventory(byte[] bytes) {
                try {
                    return jsonMapper.readValue(bytes, typeReference);
                }
                catch (IOException e) {
                    log.error(e, "Could not parse json: %s", StringUtils.fromUtf8(bytes));
                    throw new RuntimeException(e);
                }
            }

            @Override
            public void newContainer(DruidServer container) {
                log.info("New Server[%s]", container);
            }

            @Override
            public void deadContainer(DruidServer deadContainer) {
                log.info("Server Disappeared[%s]", deadContainer);
                AbstractCuratorServerInventoryView.this.runServerRemovedCallbacks(deadContainer);
            }

            @Override
            public DruidServer updateContainer(DruidServer oldContainer, DruidServer newContainer) {
                return newContainer.addDataSegments(oldContainer);
            }

            @Override
            public DruidServer addInventory(DruidServer container, String inventoryKey, InventoryType inventory) {
                return AbstractCuratorServerInventoryView.this.addInnerInventory(container, inventoryKey, inventory);
            }

            @Override
            public DruidServer updateInventory(DruidServer container, String inventoryKey, InventoryType inventory) {
                return AbstractCuratorServerInventoryView.this.updateInnerInventory(container, inventoryKey, inventory);
            }

            @Override
            public DruidServer removeInventory(DruidServer container, String inventoryKey) {
                return AbstractCuratorServerInventoryView.this.removeInnerInventory(container, inventoryKey);
            }

            @Override
            public void inventoryInitialized() {
                log.info("Inventory Initialized", new Object[0]);
                AbstractCuratorServerInventoryView.this.runSegmentCallbacks(input -> input.segmentViewInitialized());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStart
    public void start() throws Exception {
        AtomicBoolean atomicBoolean = this.started;
        synchronized (atomicBoolean) {
            if (!this.started.get()) {
                this.inventoryManager.start();
                this.started.set(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStop
    public void stop() throws IOException {
        AtomicBoolean atomicBoolean = this.started;
        synchronized (atomicBoolean) {
            if (this.started.getAndSet(false)) {
                this.inventoryManager.stop();
            }
        }
    }

    @Override
    public boolean isStarted() {
        return this.started.get();
    }

    @Override
    public DruidServer getInventoryValue(String containerKey) {
        return this.inventoryManager.getInventoryValue(containerKey);
    }

    @Override
    public Collection<DruidServer> getInventory() {
        return this.inventoryManager.getInventory();
    }

    @Override
    public void registerServerRemovedCallback(Executor exec, ServerView.ServerRemovedCallback callback) {
        this.serverRemovedCallbacks.put(callback, exec);
    }

    @Override
    public void registerSegmentCallback(Executor exec, ServerView.SegmentCallback callback) {
        this.segmentCallbacks.put(callback, exec);
    }

    public InventoryManagerConfig getInventoryManagerConfig() {
        return this.inventoryManager.getConfig();
    }

    protected void runSegmentCallbacks(Function<ServerView.SegmentCallback, ServerView.CallbackAction> fn) {
        for (Map.Entry entry : this.segmentCallbacks.entrySet()) {
            ((Executor)entry.getValue()).execute(() -> {
                if (ServerView.CallbackAction.UNREGISTER == fn.apply((ServerView.SegmentCallback)entry.getKey())) {
                    this.segmentCallbackRemoved((ServerView.SegmentCallback)entry.getKey());
                    this.segmentCallbacks.remove(entry.getKey());
                }
            });
        }
    }

    private void runServerRemovedCallbacks(DruidServer server) {
        for (Map.Entry entry : this.serverRemovedCallbacks.entrySet()) {
            ((Executor)entry.getValue()).execute(() -> {
                if (ServerView.CallbackAction.UNREGISTER == ((ServerView.ServerRemovedCallback)entry.getKey()).serverRemoved(server)) {
                    this.serverRemovedCallbacks.remove(entry.getKey());
                }
            });
        }
    }

    protected void addSingleInventory(DruidServer container, DataSegment inventory) {
        this.log.debug("Server[%s] added segment[%s]", container.getName(), inventory.getId());
        if (container.getSegment(inventory.getId()) != null) {
            this.log.warn("Not adding or running callbacks for existing segment[%s] on server[%s]", inventory.getId(), container.getName());
            return;
        }
        container.addDataSegment(inventory);
        this.runSegmentCallbacks(input -> input.segmentAdded(container.getMetadata(), inventory));
    }

    void removeSingleInventory(DruidServer container, SegmentId segmentId) {
        this.log.debug("Server[%s] removed segment[%s]", container.getName(), segmentId);
        if (!this.doRemoveSingleInventory(container, segmentId)) {
            this.log.warn("Not running cleanup or callbacks for non-existing segment[%s] on server[%s]", segmentId, container.getName());
        }
    }

    void removeSingleInventory(DruidServer container, String segmentId) {
        this.log.debug("Server[%s] removed segment[%s]", container.getName(), segmentId);
        for (SegmentId possibleSegmentId : SegmentId.iterateAllPossibleParsings(segmentId)) {
            if (!this.doRemoveSingleInventory(container, possibleSegmentId)) continue;
            return;
        }
        this.log.warn("Not running cleanup or callbacks for non-existing segment[%s] on server[%s]", segmentId, container.getName());
    }

    private boolean doRemoveSingleInventory(DruidServer container, SegmentId segmentId) {
        DataSegment segment = container.removeDataSegment(segmentId);
        if (segment != null) {
            this.runSegmentCallbacks(input -> input.segmentRemoved(container.getMetadata(), segment));
            return true;
        }
        return false;
    }

    @Override
    public boolean isSegmentLoadedByServer(String serverKey, DataSegment segment) {
        try {
            DruidServer server = this.getInventoryValue(serverKey);
            return server != null && server.getSegment(segment.getId()) != null;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    protected abstract DruidServer addInnerInventory(DruidServer var1, String var2, InventoryType var3);

    protected abstract DruidServer updateInnerInventory(DruidServer var1, String var2, InventoryType var3);

    protected abstract DruidServer removeInnerInventory(DruidServer var1, String var2);

    protected abstract void segmentCallbackRemoved(ServerView.SegmentCallback var1);
}

