/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.util.graph;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.org.apache.calcite.util.Pair;
import org.apache.hive.druid.org.apache.calcite.util.graph.DefaultDirectedGraph;
import org.apache.hive.druid.org.apache.calcite.util.graph.DefaultEdge;
import org.apache.hive.druid.org.apache.calcite.util.graph.DirectedGraph;

public class Graphs {
    private Graphs() {
    }

    public static <V, E extends DefaultEdge> List<V> predecessorListOf(DirectedGraph<V, E> graph, V vertex) {
        final List<E> edges = graph.getInwardEdges(vertex);
        return new AbstractList<V>(){

            @Override
            public V get(int index) {
                return ((DefaultEdge)edges.get((int)index)).source;
            }

            @Override
            public int size() {
                return edges.size();
            }
        };
    }

    public static <V, E extends DefaultEdge> FrozenGraph<V, E> makeImmutable(DirectedGraph<V, E> graph) {
        boolean changed;
        DefaultDirectedGraph graph1 = (DefaultDirectedGraph)graph;
        HashMap<Pair<int[], int[]>, int[]> shortestDistances = new HashMap<Pair<int[], int[]>, int[]>();
        for (DefaultDirectedGraph.VertexInfo arc : graph1.vertexMap.values()) {
            for (DefaultEdge edge : arc.outEdges) {
                Object source = graph1.source(edge);
                Object target = graph1.target(edge);
                shortestDistances.put(Pair.of(source, target), new int[]{1});
            }
        }
        do {
            ImmutableList<Pair> previous = ImmutableList.copyOf(shortestDistances.keySet());
            changed = false;
            for (DefaultEdge edge : graph.edgeSet()) {
                for (Pair edge2 : previous) {
                    if (!edge.target.equals(edge2.left)) continue;
                    Pair key = Pair.of(graph1.source(edge), edge2.right);
                    int[] bestDistance = (int[])shortestDistances.get(key);
                    int[] arc2Distance = (int[])Objects.requireNonNull(shortestDistances.get(edge2), () -> "shortestDistances.get(edge2) for " + edge2);
                    if (bestDistance != null && bestDistance[0] <= arc2Distance[0] + 1) continue;
                    shortestDistances.put(key, new int[]{arc2Distance[0] + 1});
                    changed = true;
                }
            }
        } while (changed);
        return new FrozenGraph(graph1, shortestDistances);
    }

    public static class FrozenGraph<V, E extends DefaultEdge> {
        private final DefaultDirectedGraph<V, E> graph;
        private final Map<Pair<V, V>, int[]> shortestDistances;

        FrozenGraph(DefaultDirectedGraph<V, E> graph, Map<Pair<V, V>, int[]> shortestDistances) {
            this.graph = graph;
            this.shortestDistances = shortestDistances;
        }

        public List<List<V>> getPaths(V from, V to) {
            ArrayList<List<V>> list = new ArrayList<List<V>>();
            if (from.equals(to)) {
                list.add(ImmutableList.of(from));
            }
            this.findPaths(from, to, list);
            list.sort(Comparator.comparingInt(List::size));
            return list;
        }

        public int getShortestDistance(V from, V to) {
            if (from.equals(to)) {
                return 0;
            }
            int[] distance = this.shortestDistances.get(Pair.of(from, to));
            return distance == null ? -1 : distance[0];
        }

        private void findPaths(V from, V to, List<List<V>> list) {
            if (this.getShortestDistance(from, to) == -1) {
                return;
            }
            ArrayList<V> prefix = new ArrayList<V>();
            prefix.add(from);
            this.findPathsExcluding(from, to, list, new HashSet(), prefix);
        }

        private void findPathsExcluding(V from, V to, List<List<V>> list, Set<V> excludedNodes, List<V> prefix) {
            excludedNodes.add(from);
            for (DefaultEdge edge : this.graph.edges) {
                if (!edge.source.equals(from)) continue;
                V target = this.graph.target(edge);
                if (target.equals(to)) {
                    prefix.add(target);
                    list.add(ImmutableList.copyOf(prefix));
                    prefix.remove(prefix.size() - 1);
                    continue;
                }
                if (excludedNodes.contains(target)) continue;
                prefix.add(target);
                this.findPathsExcluding(target, to, list, excludedNodes, prefix);
                prefix.remove(prefix.size() - 1);
            }
            excludedNodes.remove(from);
        }
    }
}

