/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.util.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.hive.druid.org.apache.calcite.util.graph.DefaultEdge;
import org.apache.hive.druid.org.apache.calcite.util.graph.DirectedGraph;

public class DepthFirstIterator<V, E extends DefaultEdge>
implements Iterator<V> {
    private final Iterator<V> iterator;

    public DepthFirstIterator(DirectedGraph<V, E> graph, V start) {
        this.iterator = DepthFirstIterator.buildList(graph, start).iterator();
    }

    private static <V, E extends DefaultEdge> List<V> buildList(DirectedGraph<V, E> graph, V start) {
        ArrayList list = new ArrayList();
        DepthFirstIterator.buildListRecurse(list, new HashSet(), graph, start);
        return list;
    }

    public static <V, E extends DefaultEdge> Iterable<V> of(DirectedGraph<V, E> graph, V start) {
        return DepthFirstIterator.buildList(graph, start);
    }

    public static <V, E extends DefaultEdge> void reachable(Collection<V> list, DirectedGraph<V, E> graph, V start) {
        DepthFirstIterator.buildListRecurse(list, new HashSet(), graph, start);
    }

    private static <V, E extends DefaultEdge> void buildListRecurse(Collection<V> list, Set<V> activeVertices, DirectedGraph<V, E> graph, V start) {
        if (!activeVertices.add(start)) {
            return;
        }
        list.add(start);
        List<E> edges = graph.getOutwardEdges(start);
        for (DefaultEdge edge : edges) {
            DepthFirstIterator.buildListRecurse(list, activeVertices, graph, edge.target);
        }
        activeVertices.remove(start);
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public V next() {
        return this.iterator.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

