/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.sql.type;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataType;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataTypePrecedenceList;
import org.apache.hive.druid.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.hive.druid.org.apache.calcite.util.ImmutableNullableList;
import org.apache.hive.druid.org.apache.calcite.util.Util;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SqlTypeExplicitPrecedenceList
implements RelDataTypePrecedenceList {
    private static final List<SqlTypeName> NUMERIC_TYPES = ImmutableNullableList.of(SqlTypeName.TINYINT, SqlTypeName.SMALLINT, SqlTypeName.INTEGER, SqlTypeName.BIGINT, SqlTypeName.DECIMAL, SqlTypeName.REAL, SqlTypeName.FLOAT, SqlTypeName.DOUBLE, new SqlTypeName[0]);
    private static final Map<SqlTypeName, SqlTypeExplicitPrecedenceList> TYPE_NAME_TO_PRECEDENCE_LIST = ImmutableMap.builder().put(SqlTypeName.BOOLEAN, SqlTypeExplicitPrecedenceList.list(SqlTypeName.BOOLEAN)).put(SqlTypeName.TINYINT, SqlTypeExplicitPrecedenceList.numeric(SqlTypeName.TINYINT)).put(SqlTypeName.SMALLINT, SqlTypeExplicitPrecedenceList.numeric(SqlTypeName.SMALLINT)).put(SqlTypeName.INTEGER, SqlTypeExplicitPrecedenceList.numeric(SqlTypeName.INTEGER)).put(SqlTypeName.BIGINT, SqlTypeExplicitPrecedenceList.numeric(SqlTypeName.BIGINT)).put(SqlTypeName.DECIMAL, SqlTypeExplicitPrecedenceList.numeric(SqlTypeName.DECIMAL)).put(SqlTypeName.REAL, SqlTypeExplicitPrecedenceList.numeric(SqlTypeName.REAL)).put(SqlTypeName.FLOAT, SqlTypeExplicitPrecedenceList.list(SqlTypeName.FLOAT, SqlTypeName.REAL, SqlTypeName.DOUBLE)).put(SqlTypeName.DOUBLE, SqlTypeExplicitPrecedenceList.list(SqlTypeName.DOUBLE, SqlTypeName.DECIMAL)).put(SqlTypeName.CHAR, SqlTypeExplicitPrecedenceList.list(SqlTypeName.CHAR, SqlTypeName.VARCHAR)).put(SqlTypeName.VARCHAR, SqlTypeExplicitPrecedenceList.list(SqlTypeName.VARCHAR)).put(SqlTypeName.BINARY, SqlTypeExplicitPrecedenceList.list(SqlTypeName.BINARY, SqlTypeName.VARBINARY)).put(SqlTypeName.VARBINARY, SqlTypeExplicitPrecedenceList.list(SqlTypeName.VARBINARY)).put(SqlTypeName.DATE, SqlTypeExplicitPrecedenceList.list(SqlTypeName.DATE)).put(SqlTypeName.TIME, SqlTypeExplicitPrecedenceList.list(SqlTypeName.TIME)).put(SqlTypeName.TIMESTAMP, SqlTypeExplicitPrecedenceList.list(SqlTypeName.TIMESTAMP, SqlTypeName.DATE, SqlTypeName.TIME)).put(SqlTypeName.INTERVAL_YEAR, SqlTypeExplicitPrecedenceList.list(SqlTypeName.YEAR_INTERVAL_TYPES)).put(SqlTypeName.INTERVAL_YEAR_MONTH, SqlTypeExplicitPrecedenceList.list(SqlTypeName.YEAR_INTERVAL_TYPES)).put(SqlTypeName.INTERVAL_MONTH, SqlTypeExplicitPrecedenceList.list(SqlTypeName.YEAR_INTERVAL_TYPES)).put(SqlTypeName.INTERVAL_DAY, SqlTypeExplicitPrecedenceList.list(SqlTypeName.DAY_INTERVAL_TYPES)).put(SqlTypeName.INTERVAL_DAY_HOUR, SqlTypeExplicitPrecedenceList.list(SqlTypeName.DAY_INTERVAL_TYPES)).put(SqlTypeName.INTERVAL_DAY_MINUTE, SqlTypeExplicitPrecedenceList.list(SqlTypeName.DAY_INTERVAL_TYPES)).put(SqlTypeName.INTERVAL_DAY_SECOND, SqlTypeExplicitPrecedenceList.list(SqlTypeName.DAY_INTERVAL_TYPES)).put(SqlTypeName.INTERVAL_HOUR, SqlTypeExplicitPrecedenceList.list(SqlTypeName.DAY_INTERVAL_TYPES)).put(SqlTypeName.INTERVAL_HOUR_MINUTE, SqlTypeExplicitPrecedenceList.list(SqlTypeName.DAY_INTERVAL_TYPES)).put(SqlTypeName.INTERVAL_HOUR_SECOND, SqlTypeExplicitPrecedenceList.list(SqlTypeName.DAY_INTERVAL_TYPES)).put(SqlTypeName.INTERVAL_MINUTE, SqlTypeExplicitPrecedenceList.list(SqlTypeName.DAY_INTERVAL_TYPES)).put(SqlTypeName.INTERVAL_MINUTE_SECOND, SqlTypeExplicitPrecedenceList.list(SqlTypeName.DAY_INTERVAL_TYPES)).put(SqlTypeName.INTERVAL_SECOND, SqlTypeExplicitPrecedenceList.list(SqlTypeName.DAY_INTERVAL_TYPES)).build();
    private final List<SqlTypeName> typeNames;

    public SqlTypeExplicitPrecedenceList(Iterable<SqlTypeName> typeNames) {
        this.typeNames = ImmutableNullableList.copyOf(typeNames);
    }

    private static SqlTypeExplicitPrecedenceList list(SqlTypeName ... typeNames) {
        return SqlTypeExplicitPrecedenceList.list(Arrays.asList(typeNames));
    }

    private static SqlTypeExplicitPrecedenceList list(Iterable<SqlTypeName> typeNames) {
        return new SqlTypeExplicitPrecedenceList(typeNames);
    }

    private static SqlTypeExplicitPrecedenceList numeric(SqlTypeName typeName) {
        int i = SqlTypeExplicitPrecedenceList.getListPosition(typeName, NUMERIC_TYPES);
        return new SqlTypeExplicitPrecedenceList(Util.skip(NUMERIC_TYPES, i));
    }

    @Override
    public boolean containsType(RelDataType type) {
        SqlTypeName typeName = type.getSqlTypeName();
        return typeName != null && this.typeNames.contains((Object)typeName);
    }

    @Override
    public int compareTypePrecedence(RelDataType type1, RelDataType type2) {
        assert (this.containsType(type1)) : type1;
        assert (this.containsType(type2)) : type2;
        int p1 = SqlTypeExplicitPrecedenceList.getListPosition(type1.getSqlTypeName(), this.typeNames);
        int p2 = SqlTypeExplicitPrecedenceList.getListPosition(type2.getSqlTypeName(), this.typeNames);
        return p2 - p1;
    }

    private static int getListPosition(SqlTypeName type, List<SqlTypeName> list) {
        int i = list.indexOf((Object)type);
        assert (i != -1);
        return i;
    }

    static @Nullable RelDataTypePrecedenceList getListForType(RelDataType type) {
        SqlTypeName typeName = type.getSqlTypeName();
        if (typeName == null) {
            return null;
        }
        return TYPE_NAME_TO_PRECEDENCE_LIST.get((Object)typeName);
    }
}

