/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.sql.fun;

import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataType;
import org.apache.hive.druid.org.apache.calcite.sql.SqlBinaryOperator;
import org.apache.hive.druid.org.apache.calcite.sql.SqlCall;
import org.apache.hive.druid.org.apache.calcite.sql.SqlCallBinding;
import org.apache.hive.druid.org.apache.calcite.sql.SqlKind;
import org.apache.hive.druid.org.apache.calcite.sql.SqlNode;
import org.apache.hive.druid.org.apache.calcite.sql.SqlOperandCountRange;
import org.apache.hive.druid.org.apache.calcite.sql.SqlOperator;
import org.apache.hive.druid.org.apache.calcite.sql.SqlWriter;
import org.apache.hive.druid.org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.hive.druid.org.apache.calcite.sql.type.InferTypes;
import org.apache.hive.druid.org.apache.calcite.sql.type.OperandTypes;
import org.apache.hive.druid.org.apache.calcite.sql.type.ReturnTypes;
import org.apache.hive.druid.org.apache.calcite.sql.type.SqlOperandCountRanges;
import org.apache.hive.druid.org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.hive.druid.org.apache.calcite.sql.type.SqlTypeUtil;

public class SqlPosixRegexOperator
extends SqlBinaryOperator {
    private final boolean caseSensitive;
    private final boolean negated;
    private final String operatorString;

    SqlPosixRegexOperator(String name, SqlKind kind, boolean caseSensitive, boolean negated) {
        super(name, kind, 32, true, ReturnTypes.BOOLEAN_NULLABLE, InferTypes.FIRST_KNOWN, (SqlOperandTypeChecker)OperandTypes.STRING_SAME_SAME_SAME);
        this.caseSensitive = caseSensitive;
        this.negated = negated;
        StringBuilder sb = new StringBuilder(3);
        if (this.negated) {
            sb.append("!");
        }
        sb.append("~");
        if (!this.caseSensitive) {
            sb.append("*");
        }
        this.operatorString = sb.toString();
    }

    @Override
    public SqlOperator not() {
        return SqlPosixRegexOperator.of(!this.negated, this.caseSensitive);
    }

    private static SqlOperator of(boolean negated, boolean ignoreCase) {
        if (ignoreCase) {
            return negated ? SqlStdOperatorTable.NEGATED_POSIX_REGEX_CASE_SENSITIVE : SqlStdOperatorTable.POSIX_REGEX_CASE_SENSITIVE;
        }
        return negated ? SqlStdOperatorTable.NEGATED_POSIX_REGEX_CASE_INSENSITIVE : SqlStdOperatorTable.POSIX_REGEX_CASE_INSENSITIVE;
    }

    @Override
    public SqlOperandCountRange getOperandCountRange() {
        return SqlOperandCountRanges.of(2);
    }

    @Override
    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        RelDataType op2Type;
        int operandCount = callBinding.getOperandCount();
        if (operandCount != 2) {
            throw new AssertionError((Object)("Unexpected number of args to " + callBinding.getCall() + ": " + operandCount));
        }
        RelDataType op1Type = callBinding.getOperandType(0);
        if (!SqlTypeUtil.isComparable(op1Type, op2Type = callBinding.getOperandType(1))) {
            throw new AssertionError((Object)("Incompatible first two operand types " + op1Type + " and " + op2Type));
        }
        return SqlTypeUtil.isCharTypeComparable(callBinding, callBinding.operands().subList(0, 2), throwOnFailure);
    }

    @Override
    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        SqlWriter.Frame frame = writer.startList("", "");
        ((SqlNode)call.operand(0)).unparse(writer, this.getLeftPrec(), this.getRightPrec());
        writer.print(this.operatorString);
        writer.print(" ");
        ((SqlNode)call.operand(1)).unparse(writer, this.getLeftPrec(), this.getRightPrec());
        writer.endList(frame);
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public boolean isNegated() {
        return this.negated;
    }
}

