/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.sql.fun;

import java.util.Objects;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataType;
import org.apache.hive.druid.org.apache.calcite.sql.SqlAggFunction;
import org.apache.hive.druid.org.apache.calcite.sql.SqlCall;
import org.apache.hive.druid.org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.hive.druid.org.apache.calcite.sql.SqlJsonConstructorNullClause;
import org.apache.hive.druid.org.apache.calcite.sql.SqlKind;
import org.apache.hive.druid.org.apache.calcite.sql.SqlLiteral;
import org.apache.hive.druid.org.apache.calcite.sql.SqlNode;
import org.apache.hive.druid.org.apache.calcite.sql.SqlWriter;
import org.apache.hive.druid.org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.hive.druid.org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.hive.druid.org.apache.calcite.sql.type.InferTypes;
import org.apache.hive.druid.org.apache.calcite.sql.type.OperandTypes;
import org.apache.hive.druid.org.apache.calcite.sql.type.ReturnTypes;
import org.apache.hive.druid.org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.hive.druid.org.apache.calcite.sql.validate.SqlValidator;
import org.apache.hive.druid.org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.hive.druid.org.apache.calcite.util.Optionality;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SqlJsonArrayAggAggFunction
extends SqlAggFunction {
    private final SqlJsonConstructorNullClause nullClause;

    public SqlJsonArrayAggAggFunction(SqlKind kind, SqlJsonConstructorNullClause nullClause) {
        super((Object)((Object)kind) + "_" + nullClause.name(), null, kind, ReturnTypes.VARCHAR_2000, InferTypes.ANY_NULLABLE, OperandTypes.family(SqlTypeFamily.ANY), SqlFunctionCategory.SYSTEM, false, false, Optionality.OPTIONAL);
        this.nullClause = Objects.requireNonNull(nullClause, "nullClause");
    }

    @Override
    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        assert (call.operandCount() == 1);
        SqlWriter.Frame frame = writer.startFunCall("JSON_ARRAYAGG");
        ((SqlNode)call.operand(0)).unparse(writer, leftPrec, rightPrec);
        writer.keyword(this.nullClause.sql);
        writer.endFunCall(frame);
    }

    @Override
    public RelDataType deriveType(SqlValidator validator, SqlValidatorScope scope, SqlCall call) {
        for (SqlNode operand : call.getOperandList()) {
            RelDataType nodeType = validator.deriveType(scope, operand);
            validator.setValidatedNodeType(operand, nodeType);
        }
        return this.validateOperands(validator, scope, call);
    }

    @Override
    public SqlCall createCall(@Nullable SqlLiteral functionQualifier, SqlParserPos pos, SqlNode ... operands) {
        SqlNode orderList;
        assert (operands.length == 1 || operands.length == 2);
        SqlNode valueExpr = operands[0];
        if (operands.length == 2 && (orderList = operands[1]) != null) {
            return SqlStdOperatorTable.WITHIN_GROUP.createCall(SqlParserPos.ZERO, this.createCall_(functionQualifier, pos, valueExpr), orderList);
        }
        return this.createCall_(functionQualifier, pos, valueExpr);
    }

    private SqlCall createCall_(@Nullable SqlLiteral functionQualifier, SqlParserPos pos, @Nullable SqlNode valueExpr) {
        return super.createCall(functionQualifier, pos, valueExpr);
    }

    public SqlJsonArrayAggAggFunction with(SqlJsonConstructorNullClause nullClause) {
        return this.nullClause == nullClause ? this : new SqlJsonArrayAggAggFunction(this.getKind(), nullClause);
    }

    public SqlJsonConstructorNullClause getNullClause() {
        return this.nullClause;
    }
}

