/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.sql;

import java.util.Objects;
import org.apache.hive.druid.org.apache.calcite.linq4j.Nullness;
import org.apache.hive.druid.org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.hive.druid.org.apache.calcite.sql.SqlLiteral;
import org.apache.hive.druid.org.apache.calcite.sql.SqlNode;
import org.apache.hive.druid.org.apache.calcite.sql.SqlWriter;
import org.apache.hive.druid.org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.hive.druid.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.hive.druid.org.apache.calcite.util.Litmus;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SqlIntervalLiteral
extends SqlLiteral {
    protected SqlIntervalLiteral(int sign, String intervalStr, SqlIntervalQualifier intervalQualifier, SqlTypeName sqlTypeName, SqlParserPos pos) {
        this(new IntervalValue(intervalQualifier, sign, intervalStr), sqlTypeName, pos);
    }

    private SqlIntervalLiteral(@Nullable IntervalValue intervalValue, SqlTypeName sqlTypeName, SqlParserPos pos) {
        super(intervalValue, sqlTypeName, pos);
    }

    @Override
    public SqlIntervalLiteral clone(SqlParserPos pos) {
        return new SqlIntervalLiteral((IntervalValue)this.value, this.getTypeName(), pos);
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.getDialect().unparseSqlIntervalLiteral(writer, this, leftPrec, rightPrec);
    }

    @Override
    public int signum() {
        return ((IntervalValue)Nullness.castNonNull(this.value)).signum();
    }

    public static class IntervalValue {
        private final SqlIntervalQualifier intervalQualifier;
        private final String intervalStr;
        private final int sign;

        IntervalValue(SqlIntervalQualifier intervalQualifier, int sign, String intervalStr) {
            assert (sign == -1 || sign == 1);
            assert (intervalQualifier != null);
            assert (intervalStr != null);
            this.intervalQualifier = intervalQualifier;
            this.sign = sign;
            this.intervalStr = intervalStr;
        }

        public boolean equals(@Nullable Object obj) {
            if (!(obj instanceof IntervalValue)) {
                return false;
            }
            IntervalValue that = (IntervalValue)obj;
            return this.intervalStr.equals(that.intervalStr) && this.sign == that.sign && this.intervalQualifier.equalsDeep((SqlNode)that.intervalQualifier, Litmus.IGNORE);
        }

        public int hashCode() {
            return Objects.hash(this.sign, this.intervalStr, this.intervalQualifier);
        }

        public SqlIntervalQualifier getIntervalQualifier() {
            return this.intervalQualifier;
        }

        public String getIntervalLiteral() {
            return this.intervalStr;
        }

        public int getSign() {
            return this.sign;
        }

        public int signum() {
            for (int i = 0; i < this.intervalStr.length(); ++i) {
                char ch = this.intervalStr.charAt(i);
                if (ch < '1' || ch > '9') continue;
                return this.getSign();
            }
            return 0;
        }

        public String toString() {
            return this.intervalStr;
        }
    }
}

