/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.sql;

import java.util.List;
import org.apache.hive.druid.org.apache.calcite.sql.SqlCall;
import org.apache.hive.druid.org.apache.calcite.sql.SqlIdentifier;
import org.apache.hive.druid.org.apache.calcite.sql.SqlInsertKeyword;
import org.apache.hive.druid.org.apache.calcite.sql.SqlKind;
import org.apache.hive.druid.org.apache.calcite.sql.SqlLiteral;
import org.apache.hive.druid.org.apache.calcite.sql.SqlNode;
import org.apache.hive.druid.org.apache.calcite.sql.SqlNodeList;
import org.apache.hive.druid.org.apache.calcite.sql.SqlOperator;
import org.apache.hive.druid.org.apache.calcite.sql.SqlSelect;
import org.apache.hive.druid.org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.hive.druid.org.apache.calcite.sql.SqlWriter;
import org.apache.hive.druid.org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.hive.druid.org.apache.calcite.sql.validate.SqlValidator;
import org.apache.hive.druid.org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.hive.druid.org.apache.calcite.util.ImmutableNullableList;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;

public class SqlInsert
extends SqlCall {
    public static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("INSERT", SqlKind.INSERT){

        @Override
        public SqlCall createCall(@Nullable SqlLiteral functionQualifier, SqlParserPos pos, SqlNode ... operands) {
            return new SqlInsert(pos, (SqlNodeList)operands[0], operands[1], operands[2], (SqlNodeList)operands[3]);
        }
    };
    SqlNodeList keywords;
    SqlNode targetTable;
    SqlNode source;
    @Nullable SqlNodeList columnList;

    public SqlInsert(SqlParserPos pos, SqlNodeList keywords, SqlNode targetTable, SqlNode source, @Nullable SqlNodeList columnList) {
        super(pos);
        this.keywords = keywords;
        this.targetTable = targetTable;
        this.source = source;
        this.columnList = columnList;
        assert (keywords != null);
    }

    @Override
    public SqlKind getKind() {
        return SqlKind.INSERT;
    }

    @Override
    public SqlOperator getOperator() {
        return OPERATOR;
    }

    @Override
    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of(this.keywords, this.targetTable, this.source, this.columnList);
    }

    public final boolean isUpsert() {
        return this.getModifierNode(SqlInsertKeyword.UPSERT) != null;
    }

    @Override
    public void setOperand(int i, @Nullable SqlNode operand) {
        switch (i) {
            case 0: {
                this.keywords = (SqlNodeList)operand;
                break;
            }
            case 1: {
                assert (operand instanceof SqlIdentifier);
                this.targetTable = operand;
                break;
            }
            case 2: {
                this.source = operand;
                break;
            }
            case 3: {
                this.columnList = (SqlNodeList)operand;
                break;
            }
            default: {
                throw new AssertionError(i);
            }
        }
    }

    public SqlNode getTargetTable() {
        return this.targetTable;
    }

    public SqlNode getSource() {
        return this.source;
    }

    public void setSource(SqlSelect source) {
        this.source = source;
    }

    @Pure
    public @Nullable SqlNodeList getTargetColumnList() {
        return this.columnList;
    }

    public final @Nullable SqlNode getModifierNode(SqlInsertKeyword modifier) {
        for (SqlNode keyword : this.keywords) {
            SqlInsertKeyword keyword2 = ((SqlLiteral)keyword).symbolValue(SqlInsertKeyword.class);
            if (keyword2 != modifier) continue;
            return keyword;
        }
        return null;
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.startList(SqlWriter.FrameTypeEnum.SELECT);
        writer.sep(this.isUpsert() ? "UPSERT INTO" : "INSERT INTO");
        int opLeft = this.getOperator().getLeftPrec();
        int opRight = this.getOperator().getRightPrec();
        this.targetTable.unparse(writer, opLeft, opRight);
        if (this.columnList != null) {
            this.columnList.unparse(writer, opLeft, opRight);
        }
        writer.newlineAndIndent();
        this.source.unparse(writer, 0, 0);
    }

    @Override
    public void validate(SqlValidator validator, SqlValidatorScope scope) {
        validator.validateInsert(this);
    }
}

