/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.schema.impl;

import java.lang.reflect.Type;
import java.util.List;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.org.apache.calcite.adapter.java.AbstractQueryableTable;
import org.apache.hive.druid.org.apache.calcite.jdbc.CalciteSchema;
import org.apache.hive.druid.org.apache.calcite.linq4j.QueryProvider;
import org.apache.hive.druid.org.apache.calcite.linq4j.Queryable;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptTable;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptUtil;
import org.apache.hive.druid.org.apache.calcite.rel.RelNode;
import org.apache.hive.druid.org.apache.calcite.rel.RelRoot;
import org.apache.hive.druid.org.apache.calcite.rel.RelShuttleImpl;
import org.apache.hive.druid.org.apache.calcite.rel.core.TableScan;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataType;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelProtoDataType;
import org.apache.hive.druid.org.apache.calcite.schema.Schema;
import org.apache.hive.druid.org.apache.calcite.schema.SchemaPlus;
import org.apache.hive.druid.org.apache.calcite.schema.TranslatableTable;
import org.apache.hive.druid.org.apache.calcite.schema.impl.ViewTableMacro;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ViewTable
extends AbstractQueryableTable
implements TranslatableTable {
    private final String viewSql;
    private final List<String> schemaPath;
    private final RelProtoDataType protoRowType;
    private final @Nullable List<String> viewPath;

    public ViewTable(Type elementType, RelProtoDataType rowType, String viewSql, List<String> schemaPath, @Nullable List<String> viewPath) {
        super(elementType);
        this.viewSql = viewSql;
        this.schemaPath = ImmutableList.copyOf(schemaPath);
        this.protoRowType = rowType;
        this.viewPath = viewPath == null ? null : ImmutableList.copyOf(viewPath);
    }

    @Deprecated
    public static ViewTableMacro viewMacro(SchemaPlus schema, String viewSql, List<String> schemaPath) {
        return ViewTable.viewMacro(schema, viewSql, schemaPath, null, Boolean.TRUE);
    }

    @Deprecated
    public static ViewTableMacro viewMacro(SchemaPlus schema, String viewSql, List<String> schemaPath, @Nullable Boolean modifiable) {
        return ViewTable.viewMacro(schema, viewSql, schemaPath, null, modifiable);
    }

    public static ViewTableMacro viewMacro(SchemaPlus schema, String viewSql, List<String> schemaPath, @Nullable List<String> viewPath, @Nullable Boolean modifiable) {
        return new ViewTableMacro(CalciteSchema.from(schema), viewSql, schemaPath, viewPath, modifiable);
    }

    public String getViewSql() {
        return this.viewSql;
    }

    public List<String> getSchemaPath() {
        return this.schemaPath;
    }

    public @Nullable List<String> getViewPath() {
        return this.viewPath;
    }

    @Override
    public Schema.TableType getJdbcTableType() {
        return Schema.TableType.VIEW;
    }

    @Override
    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
        return (RelDataType)this.protoRowType.apply(typeFactory);
    }

    @Override
    public <T> Queryable<T> asQueryable(QueryProvider queryProvider, SchemaPlus schema, String tableName) {
        return queryProvider.createQuery(this.getExpression(schema, tableName, Queryable.class), this.elementType);
    }

    @Override
    public RelNode toRel(RelOptTable.ToRelContext context, RelOptTable relOptTable) {
        return this.expandView((RelOptTable.ToRelContext)context, (RelDataType)relOptTable.getRowType(), (String)this.viewSql).rel;
    }

    private RelRoot expandView(final RelOptTable.ToRelContext context, RelDataType rowType, String queryString) {
        try {
            RelRoot root = context.expandView(rowType, queryString, this.schemaPath, this.viewPath);
            RelNode rel = RelOptUtil.createCastRel(root.rel, rowType, true);
            RelNode rel2 = rel.accept(new RelShuttleImpl(){

                @Override
                public RelNode visit(TableScan scan) {
                    RelOptTable table = scan.getTable();
                    TranslatableTable translatableTable = table.unwrap(TranslatableTable.class);
                    if (translatableTable != null) {
                        return translatableTable.toRel(context, table);
                    }
                    return super.visit(scan);
                }
            });
            return root.withRel(rel2);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while parsing view definition: " + queryString, e);
        }
    }
}

