/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.rel.rules;

import java.util.ArrayList;
import java.util.List;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptRuleCall;
import org.apache.hive.druid.org.apache.calcite.plan.RelRule;
import org.apache.hive.druid.org.apache.calcite.rel.core.Aggregate;
import org.apache.hive.druid.org.apache.calcite.rel.core.JoinRelType;
import org.apache.hive.druid.org.apache.calcite.rel.core.Project;
import org.apache.hive.druid.org.apache.calcite.rel.rules.ImmutableAggregateProjectConstantToDummyJoinRule;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.hive.druid.org.apache.calcite.rex.RexBuilder;
import org.apache.hive.druid.org.apache.calcite.rex.RexLiteral;
import org.apache.hive.druid.org.apache.calcite.rex.RexNode;
import org.apache.hive.druid.org.apache.calcite.tools.RelBuilder;
import org.apache.hive.druid.org.apache.calcite.util.ImmutableBitSet;
import org.immutables.value.Value;

@Value.Enclosing
public final class AggregateProjectConstantToDummyJoinRule
extends RelRule<Config> {
    private AggregateProjectConstantToDummyJoinRule(Config config) {
        super(config);
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        Aggregate aggregate = (Aggregate)call.rel(0);
        Project project = (Project)call.rel(1);
        for (int groupKey : aggregate.getGroupSet().asList()) {
            RexNode groupKeyProject;
            if (groupKey >= aggregate.getRowType().getFieldCount() || !((groupKeyProject = project.getProjects().get(groupKey)) instanceof RexLiteral)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Aggregate aggregate = (Aggregate)call.rel(0);
        Project project = (Project)call.rel(1);
        RelBuilder builder = call.builder();
        RexBuilder rexBuilder = builder.getRexBuilder();
        builder.push(project.getInput());
        int offset = project.getInput().getRowType().getFieldCount();
        RelDataTypeFactory.FieldInfoBuilder valuesType = rexBuilder.getTypeFactory().builder();
        ArrayList<RexLiteral> literals = new ArrayList<RexLiteral>();
        List<RexNode> projects = project.getProjects();
        for (int i = 0; i < projects.size(); ++i) {
            RexNode node = projects.get(i);
            if (!(node instanceof RexLiteral)) continue;
            literals.add((RexLiteral)node);
            ((RelDataTypeFactory.Builder)valuesType).add(project.getRowType().getFieldList().get(i));
        }
        builder.values(ImmutableList.of(literals), valuesType.build());
        builder.join(JoinRelType.INNER, rexBuilder.makeLiteral(true));
        ArrayList<RexNode> newProjects = new ArrayList<RexNode>();
        int literalCounter = 0;
        for (RexNode exp : project.getProjects()) {
            if (exp instanceof RexLiteral) {
                newProjects.add(builder.field(offset + literalCounter++));
                continue;
            }
            newProjects.add(exp);
        }
        builder.project(newProjects);
        builder.aggregate(builder.groupKey(aggregate.getGroupSet(), (Iterable<? extends ImmutableBitSet>)aggregate.getGroupSets()), aggregate.getAggCallList());
        call.transformTo(builder.build());
    }

    @Value.Immutable
    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = ImmutableAggregateProjectConstantToDummyJoinRule.Config.of().withOperandFor(Aggregate.class, Project.class);

        @Override
        default public AggregateProjectConstantToDummyJoinRule toRule() {
            return new AggregateProjectConstantToDummyJoinRule(this);
        }

        default public Config withOperandFor(Class<? extends Aggregate> aggregateClass, Class<? extends Project> projectClass) {
            return this.withOperandSupplier(b0 -> b0.operand(aggregateClass).oneInput(b1 -> b1.operand(projectClass).anyInputs())).as(Config.class);
        }
    }
}

