/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.rel.metadata;

import org.apache.hive.druid.org.apache.calcite.rel.RelNode;
import org.apache.hive.druid.org.apache.calcite.rel.metadata.BuiltInMetadata;
import org.apache.hive.druid.org.apache.calcite.rel.metadata.MetadataDef;
import org.apache.hive.druid.org.apache.calcite.rel.metadata.MetadataHandler;
import org.apache.hive.druid.org.apache.calcite.rel.metadata.ReflectiveRelMetadataProvider;
import org.apache.hive.druid.org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.hive.druid.org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.checkerframework.checker.nullness.qual.Nullable;

public class RelMdMemory
implements MetadataHandler<BuiltInMetadata.Memory> {
    public static final RelMetadataProvider SOURCE = ReflectiveRelMetadataProvider.reflectiveSource(new RelMdMemory(), BuiltInMetadata.Memory.Handler.class);

    protected RelMdMemory() {
    }

    @Override
    public MetadataDef<BuiltInMetadata.Memory> getDef() {
        return BuiltInMetadata.Memory.DEF;
    }

    public @Nullable Double memory(RelNode rel, RelMetadataQuery mq) {
        return null;
    }

    public @Nullable Double cumulativeMemoryWithinPhase(RelNode rel, RelMetadataQuery mq) {
        Double nullable = mq.memory(rel);
        if (nullable == null) {
            return null;
        }
        Boolean isPhaseTransition = mq.isPhaseTransition(rel);
        if (isPhaseTransition == null) {
            return null;
        }
        double d = nullable;
        if (!isPhaseTransition.booleanValue()) {
            for (RelNode input : rel.getInputs()) {
                nullable = mq.cumulativeMemoryWithinPhase(input);
                if (nullable == null) {
                    return null;
                }
                d += nullable.doubleValue();
            }
        }
        return d;
    }

    public @Nullable Double cumulativeMemoryWithinPhaseSplit(RelNode rel, RelMetadataQuery mq) {
        Double memoryWithinPhase = mq.cumulativeMemoryWithinPhase(rel);
        Integer splitCount = mq.splitCount(rel);
        if (memoryWithinPhase == null || splitCount == null) {
            return null;
        }
        return memoryWithinPhase / (double)splitCount.intValue();
    }
}

