/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.interpreter;

import java.util.ArrayList;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.org.apache.calcite.interpreter.Compiler;
import org.apache.hive.druid.org.apache.calcite.interpreter.Context;
import org.apache.hive.druid.org.apache.calcite.interpreter.Node;
import org.apache.hive.druid.org.apache.calcite.interpreter.Row;
import org.apache.hive.druid.org.apache.calcite.interpreter.Scalar;
import org.apache.hive.druid.org.apache.calcite.interpreter.Sink;
import org.apache.hive.druid.org.apache.calcite.rel.core.Values;
import org.apache.hive.druid.org.apache.calcite.rex.RexLiteral;
import org.apache.hive.druid.org.apache.calcite.rex.RexNode;

public class ValuesNode
implements Node {
    private final Sink sink;
    private final int fieldCount;
    private final ImmutableList<Row> rows;

    public ValuesNode(Compiler compiler, Values rel) {
        this.sink = compiler.sink(rel);
        this.fieldCount = rel.getRowType().getFieldCount();
        this.rows = ValuesNode.createRows(compiler, this.fieldCount, rel.getTuples());
    }

    private static ImmutableList<Row> createRows(Compiler compiler, int fieldCount, ImmutableList<ImmutableList<RexLiteral>> tuples) {
        ArrayList<RexNode> nodes = new ArrayList<RexNode>();
        for (ImmutableList immutableList : tuples) {
            nodes.addAll(immutableList);
        }
        Scalar scalar = compiler.compile(nodes, null);
        Object[] objectArray = new Object[nodes.size()];
        Context context = compiler.createContext();
        scalar.execute(context, objectArray);
        ImmutableList.Builder rows = ImmutableList.builder();
        Object[] subValues = new Object[fieldCount];
        int n = tuples.size();
        for (int r = 0; r < n; ++r) {
            System.arraycopy(objectArray, r * fieldCount, subValues, 0, fieldCount);
            rows.add(Row.asCopy(subValues));
        }
        return rows.build();
    }

    @Override
    public void run() throws InterruptedException {
        for (Row row : this.rows) {
            this.sink.send(row);
        }
        this.sink.end();
    }
}

