/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.adapter.druid;

import org.apache.hive.druid.org.apache.calcite.adapter.druid.DruidExpressions;
import org.apache.hive.druid.org.apache.calcite.adapter.druid.DruidQuery;
import org.apache.hive.druid.org.apache.calcite.adapter.druid.DruidSqlOperatorConverter;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataType;
import org.apache.hive.druid.org.apache.calcite.rex.RexCall;
import org.apache.hive.druid.org.apache.calcite.rex.RexLiteral;
import org.apache.hive.druid.org.apache.calcite.rex.RexNode;
import org.apache.hive.druid.org.apache.calcite.sql.SqlKind;
import org.apache.hive.druid.org.apache.calcite.sql.SqlOperator;
import org.apache.hive.druid.org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SubstringOperatorConversion
implements DruidSqlOperatorConverter {
    @Override
    public SqlOperator calciteOperator() {
        return SqlStdOperatorTable.SUBSTRING;
    }

    @Override
    public @Nullable String toDruidExpression(RexNode rexNode, RelDataType rowType, DruidQuery query) {
        String length;
        String startIndex;
        RexCall call = (RexCall)rexNode;
        String arg = DruidExpressions.toDruidExpression(call.getOperands().get(0), rowType, query);
        if (arg == null) {
            return null;
        }
        if (!call.getOperands().get(1).isA(SqlKind.LITERAL)) {
            String arg1 = DruidExpressions.toDruidExpression(call.getOperands().get(1), rowType, query);
            if (arg1 == null) {
                return null;
            }
            startIndex = DruidQuery.format("(%s - 1)", arg1);
        } else {
            startIndex = DruidExpressions.numberLiteral(RexLiteral.intValue(call.getOperands().get(1)) - 1);
        }
        if (call.getOperands().size() > 2) {
            if (!call.getOperands().get(2).isA(SqlKind.LITERAL)) {
                length = DruidExpressions.toDruidExpression(call.getOperands().get(2), rowType, query);
                if (length == null) {
                    return null;
                }
            } else {
                length = DruidExpressions.numberLiteral(RexLiteral.intValue(call.getOperands().get(2)));
            }
        } else {
            length = DruidExpressions.numberLiteral(-1);
        }
        return DruidQuery.format("substring(%s, %s, %s)", arg, startIndex, length);
    }
}

