/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.druid.serde;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.hadoop.io.Writable;
import org.apache.hive.druid.com.google.common.collect.Lists;

public class DruidWritable
implements Writable {
    private final Map<String, Object> value;
    private transient List<Object> compactedValue;
    private final boolean compacted;

    public DruidWritable(boolean compacted) {
        this.compacted = compacted;
        if (compacted) {
            this.compactedValue = Lists.newArrayList();
            this.value = null;
        } else {
            this.value = new HashMap<String, Object>();
            this.compactedValue = null;
        }
    }

    public DruidWritable(Map<String, Object> value) {
        this.value = value;
        this.compactedValue = null;
        this.compacted = false;
    }

    public DruidWritable(List<Object> value) {
        this.compacted = true;
        this.compactedValue = value;
        this.value = null;
    }

    public Map<String, Object> getValue() {
        if (this.compacted) {
            throw new UnsupportedOperationException("compacted DruidWritable does not support getValue(), use getCompactedValue()");
        }
        return this.value;
    }

    List<Object> getCompactedValue() {
        if (!this.compacted) {
            throw new UnsupportedOperationException("non compacted DruidWritable does not support getCompactedValue(), use getValue()");
        }
        return this.compactedValue;
    }

    void setCompactedValue(List<Object> compactedValue) {
        this.compactedValue = compactedValue;
    }

    boolean isCompacted() {
        return this.compacted;
    }

    public void write(DataOutput out) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void readFields(DataInput in) throws IOException {
        throw new UnsupportedOperationException();
    }

    public int hashCode() {
        return Objects.hash(this.value, this.compactedValue, this.compacted);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DruidWritable that = (DruidWritable)o;
        return this.compacted == that.compacted && Objects.equals(this.value, that.value) && Objects.equals(this.compactedValue, that.compactedValue);
    }

    public String toString() {
        return "DruidWritable{value=" + String.valueOf(this.value) + ", compactedValue=" + String.valueOf(this.compactedValue) + ", compacted=" + this.compacted + "}";
    }
}

