/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.druid.serde;

import java.io.IOException;
import java.io.InputStream;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.type.Date;
import org.apache.hadoop.hive.common.type.HiveChar;
import org.apache.hadoop.hive.common.type.HiveVarchar;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hadoop.hive.common.type.TimestampTZ;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.druid.DruidStorageHandler;
import org.apache.hadoop.hive.druid.DruidStorageHandlerUtils;
import org.apache.hadoop.hive.druid.serde.DruidSerDeUtils;
import org.apache.hadoop.hive.druid.serde.DruidWritable;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeSpec;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.AbstractPrimitiveJavaObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.AbstractPrimitiveWritableObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BooleanObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ByteObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DoubleObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.FloatObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveCharObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveVarcharObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.IntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.LongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ShortObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.TimestampLocalTZObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.TimestampObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.CharTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TimestampLocalTZTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.hive.serde2.typeinfo.VarcharTypeInfo;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.StringUtils;
import org.apache.hive.druid.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.org.apache.druid.query.Druids;
import org.apache.hive.druid.org.apache.druid.query.metadata.metadata.ColumnAnalysis;
import org.apache.hive.druid.org.apache.druid.query.metadata.metadata.SegmentAnalysis;
import org.apache.hive.druid.org.apache.druid.query.metadata.metadata.SegmentMetadataQuery;
import org.joda.time.format.ISODateTimeFormat;

@SerDeSpec(schemaProps={"druid.datasource"})
public class DruidSerDe
extends AbstractSerDe {
    private String[] columns;
    private PrimitiveTypeInfo[] types;
    private ObjectInspector inspector;
    private TimestampLocalTZTypeInfo tsTZTypeInfo;

    public void initialize(Configuration configuration, Properties tableProperties, Properties partitionProperties) throws SerDeException {
        super.initialize(configuration, tableProperties, partitionProperties);
        this.tsTZTypeInfo = new TimestampLocalTZTypeInfo(configuration.get(HiveConf.ConfVars.HIVE_LOCAL_TIME_ZONE.varname));
        String druidQuery = this.properties.getProperty("druid.query.json", null);
        if (druidQuery != null && !druidQuery.isEmpty()) {
            this.initFromDruidQueryPlan(this.properties, druidQuery);
        } else if (!org.apache.commons.lang3.StringUtils.isEmpty(this.properties.getProperty("columns")) && !org.apache.commons.lang3.StringUtils.isEmpty(this.properties.getProperty("columns.types"))) {
            this.initFromProperties(this.properties);
        } else {
            this.initFromMetaDataQuery(configuration, this.properties);
        }
        if (log.isDebugEnabled()) {
            log.debug("DruidSerDe initialized with\n\t columns: " + Arrays.toString(this.columns) + "\n\t types: " + Arrays.toString(this.types));
        }
    }

    private void initFromMetaDataQuery(Configuration configuration, Properties properties) throws SerDeException {
        SegmentAnalysis schemaInfo;
        ArrayList<String> columnNames = new ArrayList<String>();
        ArrayList<TimestampLocalTZTypeInfo> columnTypes = new ArrayList<TimestampLocalTZTypeInfo>();
        ArrayList<AbstractPrimitiveWritableObjectInspector> inspectors = new ArrayList<AbstractPrimitiveWritableObjectInspector>();
        String dataSource = properties.getProperty("druid.datasource");
        if (dataSource == null) {
            throw new SerDeException("Druid data source not specified; use druid.datasource in table properties");
        }
        Druids.SegmentMetadataQueryBuilder builder = new Druids.SegmentMetadataQueryBuilder();
        builder.dataSource(dataSource);
        builder.merge(true);
        builder.analysisTypes(new SegmentMetadataQuery.AnalysisType[0]);
        SegmentMetadataQuery query = builder.build();
        String address = HiveConf.getVar((Configuration)configuration, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_DRUID_BROKER_DEFAULT_ADDRESS);
        if (org.apache.commons.lang3.StringUtils.isEmpty(address)) {
            throw new SerDeException("Druid broker address not specified in configuration");
        }
        try {
            schemaInfo = this.submitMetadataRequest(address, query);
        }
        catch (IOException e) {
            throw new SerDeException((Throwable)e);
        }
        for (Map.Entry<String, ColumnAnalysis> columnInfo : schemaInfo.getColumns().entrySet()) {
            TimestampLocalTZTypeInfo type;
            if (columnInfo.getKey().equals("__time")) {
                columnNames.add(columnInfo.getKey());
                type = this.tsTZTypeInfo;
                columnTypes.add(type);
                inspectors.add(PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)type));
                continue;
            }
            columnNames.add(columnInfo.getKey());
            type = DruidSerDeUtils.convertDruidToHiveType(columnInfo.getValue().getType());
            columnTypes.add(type instanceof TimestampLocalTZTypeInfo ? this.tsTZTypeInfo : type);
            inspectors.add(PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)type));
        }
        this.columns = columnNames.toArray(new String[0]);
        this.types = columnTypes.toArray(new PrimitiveTypeInfo[0]);
        this.inspector = ObjectInspectorFactory.getStandardStructObjectInspector(columnNames, inspectors);
    }

    private void initFromProperties(Properties properties) throws SerDeException {
        ArrayList columnNames = new ArrayList(Utilities.getColumnNames((Properties)properties));
        if (!columnNames.contains("__time")) {
            throw new SerDeException("Timestamp column (' __time') not specified in create table; list of columns is : " + properties.getProperty("columns"));
        }
        List<PrimitiveTypeInfo> columnTypes = Utilities.getColumnTypes((Properties)properties).stream().map(TypeInfoFactory::getPrimitiveTypeInfo).collect(Collectors.toList()).stream().map(e -> e instanceof TimestampLocalTZTypeInfo ? this.tsTZTypeInfo : e).collect(Collectors.toList());
        List inspectors = columnTypes.stream().map(PrimitiveObjectInspectorFactory::getPrimitiveJavaObjectInspector).collect(Collectors.toList());
        this.columns = columnNames.toArray(new String[0]);
        this.types = columnTypes.toArray(new PrimitiveTypeInfo[0]);
        this.inspector = ObjectInspectorFactory.getStandardStructObjectInspector(columnNames, inspectors);
    }

    private void initFromDruidQueryPlan(Properties properties, String druidQuery) {
        List columnTypes;
        List columnNames;
        Preconditions.checkNotNull(druidQuery, "Why Druid query is null");
        ArrayList<AbstractPrimitiveJavaObjectInspector> inspectors = new ArrayList<AbstractPrimitiveJavaObjectInspector>();
        String fieldNamesProperty = Preconditions.checkNotNull(properties.getProperty("druid.fieldNames", null));
        String fieldTypesProperty = Preconditions.checkNotNull(properties.getProperty("druid.fieldTypes", null));
        if (fieldNamesProperty.isEmpty()) {
            columnNames = Collections.emptyList();
            columnTypes = Collections.emptyList();
        } else {
            columnNames = Arrays.stream(fieldNamesProperty.trim().split(",")).collect(Collectors.toList());
            columnTypes = TypeInfoUtils.getTypeInfosFromTypeString((String)fieldTypesProperty).stream().map(e -> TypeInfoFactory.getPrimitiveTypeInfo((String)e.getTypeName())).map(primitiveTypeInfo -> {
                if (primitiveTypeInfo instanceof TimestampLocalTZTypeInfo) {
                    return this.tsTZTypeInfo;
                }
                return primitiveTypeInfo;
            }).collect(Collectors.toList());
        }
        this.columns = new String[columnNames.size()];
        this.types = new PrimitiveTypeInfo[columnNames.size()];
        for (int i = 0; i < columnTypes.size(); ++i) {
            this.columns[i] = (String)columnNames.get(i);
            this.types[i] = (PrimitiveTypeInfo)columnTypes.get(i);
            inspectors.add(PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector((PrimitiveTypeInfo)this.types[i]));
        }
        this.inspector = ObjectInspectorFactory.getStandardStructObjectInspector(columnNames, inspectors);
    }

    protected SegmentAnalysis submitMetadataRequest(String address, SegmentMetadataQuery query) throws SerDeException, IOException {
        List<SegmentAnalysis> resultsList;
        InputStream response;
        try {
            response = DruidStorageHandlerUtils.submitRequest(DruidStorageHandler.getHttpClient(), DruidStorageHandlerUtils.createSmileRequest(address, query));
        }
        catch (Exception e) {
            throw new SerDeException(StringUtils.stringifyException((Throwable)e));
        }
        try {
            resultsList = DruidStorageHandlerUtils.SMILE_MAPPER.readValue(response, new TypeReference<List<SegmentAnalysis>>(this){});
        }
        catch (Exception e) {
            response.close();
            throw new SerDeException(StringUtils.stringifyException((Throwable)e));
        }
        if (resultsList == null || resultsList.isEmpty()) {
            throw new SerDeException("Connected to Druid but could not retrieve datasource information");
        }
        if (resultsList.size() != 1) {
            throw new SerDeException("Information about segments should have been merged");
        }
        return resultsList.get(0);
    }

    public Class<? extends Writable> getSerializedClass() {
        return DruidWritable.class;
    }

    public Writable serialize(Object o, ObjectInspector objectInspector) throws SerDeException {
        if (objectInspector.getCategory() != ObjectInspector.Category.STRUCT) {
            throw new SerDeException(((Object)((Object)this)).getClass().toString() + " can only serialize struct types, but we got: " + objectInspector.getTypeName());
        }
        StructObjectInspector soi = (StructObjectInspector)objectInspector;
        List fields = soi.getAllStructFieldRefs();
        List values = soi.getStructFieldsDataAsList(o);
        HashMap<String, Object> value = new HashMap<String, Object>();
        for (int i = 0; i < this.columns.length; ++i) {
            if (values.get(i) == null) {
                value.put(this.columns[i], null);
                continue;
            }
            value.put(this.columns[i], switch (this.types[i].getPrimitiveCategory()) {
                case PrimitiveObjectInspector.PrimitiveCategory.TIMESTAMP -> ((TimestampObjectInspector)((StructField)fields.get(i)).getFieldObjectInspector()).getPrimitiveJavaObject(values.get(i)).toEpochMilli();
                case PrimitiveObjectInspector.PrimitiveCategory.TIMESTAMPLOCALTZ -> ((TimestampLocalTZObjectInspector)((StructField)fields.get(i)).getFieldObjectInspector()).getPrimitiveJavaObject(values.get(i)).getZonedDateTime().toInstant().toEpochMilli();
                case PrimitiveObjectInspector.PrimitiveCategory.BYTE -> ((ByteObjectInspector)((StructField)fields.get(i)).getFieldObjectInspector()).get(values.get(i));
                case PrimitiveObjectInspector.PrimitiveCategory.SHORT -> ((ShortObjectInspector)((StructField)fields.get(i)).getFieldObjectInspector()).get(values.get(i));
                case PrimitiveObjectInspector.PrimitiveCategory.INT -> ((IntObjectInspector)((StructField)fields.get(i)).getFieldObjectInspector()).get(values.get(i));
                case PrimitiveObjectInspector.PrimitiveCategory.LONG -> ((LongObjectInspector)((StructField)fields.get(i)).getFieldObjectInspector()).get(values.get(i));
                case PrimitiveObjectInspector.PrimitiveCategory.FLOAT -> Float.valueOf(((FloatObjectInspector)((StructField)fields.get(i)).getFieldObjectInspector()).get(values.get(i)));
                case PrimitiveObjectInspector.PrimitiveCategory.DOUBLE -> ((DoubleObjectInspector)((StructField)fields.get(i)).getFieldObjectInspector()).get(values.get(i));
                case PrimitiveObjectInspector.PrimitiveCategory.CHAR -> ((HiveCharObjectInspector)((StructField)fields.get(i)).getFieldObjectInspector()).getPrimitiveJavaObject(values.get(i)).getValue();
                case PrimitiveObjectInspector.PrimitiveCategory.VARCHAR -> ((HiveVarcharObjectInspector)((StructField)fields.get(i)).getFieldObjectInspector()).getPrimitiveJavaObject(values.get(i)).getValue();
                case PrimitiveObjectInspector.PrimitiveCategory.STRING -> ((StringObjectInspector)((StructField)fields.get(i)).getFieldObjectInspector()).getPrimitiveJavaObject(values.get(i));
                case PrimitiveObjectInspector.PrimitiveCategory.BOOLEAN -> ((BooleanObjectInspector)((StructField)fields.get(i)).getFieldObjectInspector()).get(values.get(i)) ? 1L : 0L;
                default -> throw new SerDeException("Unsupported type: " + String.valueOf(this.types[i].getPrimitiveCategory()));
            });
        }
        int granularityFieldIndex = this.columns.length;
        assert (values.size() > granularityFieldIndex);
        Preconditions.checkArgument(((StructField)fields.get(granularityFieldIndex)).getFieldName().equals("__time_granularity"));
        Timestamp timestamp = ((TimestampObjectInspector)((StructField)fields.get(granularityFieldIndex)).getFieldObjectInspector()).getPrimitiveJavaObject(values.get(granularityFieldIndex));
        Preconditions.checkNotNull(timestamp, "Timestamp column cannot have null value");
        value.put("__time_granularity", timestamp.toEpochMilli());
        if (values.size() == this.columns.length + 2) {
            int partitionNumPos = granularityFieldIndex + 1;
            Preconditions.checkArgument(((StructField)fields.get(partitionNumPos)).getFieldName().equals("__druid_extra_partition_key"), String.format("expecting to encounter %s but was %s", "__druid_extra_partition_key", ((StructField)fields.get(partitionNumPos)).getFieldName()));
            value.put("__druid_extra_partition_key", ((LongObjectInspector)((StructField)fields.get(partitionNumPos)).getFieldObjectInspector()).get(values.get(partitionNumPos)));
        }
        return new DruidWritable(value);
    }

    public Object deserialize(Writable writable) throws SerDeException {
        DruidWritable input = (DruidWritable)writable;
        ArrayList<Object> output = Lists.newArrayListWithExpectedSize(this.columns.length);
        for (int i = 0; i < this.columns.length; ++i) {
            Object value;
            Object object = value = input.isCompacted() ? input.getCompactedValue().get(i) : input.getValue().get(this.columns[i]);
            if (value == null) {
                output.add(null);
                continue;
            }
            output.add(DruidSerDe.convertAsPrimitive(value, this.types[i]));
        }
        return output;
    }

    public void deserializeAsPrimitive(Writable writable, Object[] rowBoat) throws SerDeException {
        DruidWritable input = (DruidWritable)writable;
        for (int i = 0; i < this.columns.length; ++i) {
            Object value = input.isCompacted() ? input.getCompactedValue().get(i) : input.getValue().get(this.columns[i]);
            rowBoat[i] = null;
            if (value == null) continue;
            rowBoat[i] = DruidSerDe.convertAsPrimitive(value, this.types[i]);
        }
    }

    private static Object convertAsPrimitive(Object value, PrimitiveTypeInfo typeInfo) throws SerDeException {
        switch (typeInfo.getPrimitiveCategory()) {
            case TIMESTAMP: {
                return Timestamp.ofEpochMilli((long)DruidSerDe.deserializeToMillis(value));
            }
            case TIMESTAMPLOCALTZ: {
                return new TimestampTZ(ZonedDateTime.ofInstant(Instant.ofEpochMilli(DruidSerDe.deserializeToMillis(value)), ((TimestampLocalTZTypeInfo)typeInfo).timeZone()));
            }
            case DATE: {
                return Date.ofEpochMilli((long)DruidSerDe.deserializeToMillis(value));
            }
            case BYTE: {
                return ((Number)value).byteValue();
            }
            case SHORT: {
                return ((Number)value).shortValue();
            }
            case INT: {
                if (value instanceof Number) {
                    return ((Number)value).intValue();
                }
                return Integer.valueOf((String)value);
            }
            case LONG: {
                return ((Number)value).longValue();
            }
            case FLOAT: {
                return Float.valueOf(((Number)value).floatValue());
            }
            case DOUBLE: {
                return ((Number)value).doubleValue();
            }
            case CHAR: {
                return new HiveChar(value.toString(), ((CharTypeInfo)typeInfo).getLength());
            }
            case VARCHAR: {
                return new HiveVarchar(value.toString(), ((VarcharTypeInfo)typeInfo).getLength());
            }
            case STRING: {
                return value.toString();
            }
            case BOOLEAN: {
                if (value instanceof Number) {
                    return ((Number)value).intValue() != 0;
                }
                return Boolean.valueOf(value.toString());
            }
        }
        throw new SerDeException("Unknown type: " + String.valueOf(typeInfo.getPrimitiveCategory()));
    }

    private static long deserializeToMillis(Object value) {
        long numberOfMillis;
        if (value instanceof Number) {
            numberOfMillis = ((Number)value).longValue();
        } else {
            try {
                numberOfMillis = ISODateTimeFormat.dateOptionalTimeParser().parseDateTime((String)value).getMillis();
            }
            catch (IllegalArgumentException e) {
                numberOfMillis = Timestamp.valueOf((String)((String)value)).toEpochMilli();
            }
        }
        return numberOfMillis;
    }

    public ObjectInspector getObjectInspector() {
        return this.inspector;
    }

    public boolean shouldStoreFieldsInMetastore(Map<String, String> tableParams) {
        return true;
    }
}

