/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.druid.serde;

import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.hive.druid.DruidStorageHandlerUtils;
import org.apache.hadoop.hive.druid.serde.DruidQueryRecordReader;
import org.apache.hadoop.hive.druid.serde.DruidWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hive.druid.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.hive.druid.com.fasterxml.jackson.databind.JavaType;
import org.apache.hive.druid.org.apache.druid.data.input.MapBasedRow;
import org.apache.hive.druid.org.apache.druid.data.input.Row;

public class DruidGroupByQueryRecordReader
extends DruidQueryRecordReader<Row> {
    private static final TypeReference<Row> TYPE_REFERENCE = new TypeReference<Row>(){};
    private MapBasedRow currentRow;
    private Map<String, Object> currentEvent;

    @Override
    protected JavaType getResultTypeDef() {
        return DruidStorageHandlerUtils.JSON_MAPPER.getTypeFactory().constructType(TYPE_REFERENCE);
    }

    @Override
    public boolean nextKeyValue() {
        if (this.getQueryResultsIterator().hasNext()) {
            Row row = (Row)this.getQueryResultsIterator().next();
            this.currentRow = (MapBasedRow)row;
            this.currentEvent = this.currentRow.getEvent();
            return true;
        }
        return false;
    }

    @Override
    public NullWritable getCurrentKey() throws IOException, InterruptedException {
        return NullWritable.get();
    }

    @Override
    public DruidWritable getCurrentValue() throws IOException, InterruptedException {
        DruidWritable value = new DruidWritable(false);
        value.getValue().put("timestamp", this.currentRow.getTimestamp() == null ? null : Long.valueOf(this.currentRow.getTimestamp().getMillis()));
        value.getValue().putAll(this.currentEvent);
        return value;
    }

    @Override
    public boolean next(NullWritable key, DruidWritable value) {
        if (this.nextKeyValue()) {
            value.getValue().clear();
            value.getValue().put("timestamp", this.currentRow.getTimestamp() == null ? null : Long.valueOf(this.currentRow.getTimestamp().getMillis()));
            value.getValue().putAll(this.currentEvent);
            return true;
        }
        return false;
    }

    @Override
    public float getProgress() throws IOException {
        return this.getQueryResultsIterator().hasNext() ? 0.0f : 1.0f;
    }
}

