/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.druid.security;

import java.io.IOException;
import java.net.CookieManager;
import java.net.URI;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.org.apache.druid.java.util.http.client.response.ClientResponse;
import org.apache.hive.druid.org.apache.druid.java.util.http.client.response.HttpResponseHandler;
import org.apache.hive.druid.org.jboss.netty.handler.codec.http.HttpChunk;
import org.apache.hive.druid.org.jboss.netty.handler.codec.http.HttpHeaders;
import org.apache.hive.druid.org.jboss.netty.handler.codec.http.HttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseCookieHandler<Intermediate, Final>
implements HttpResponseHandler<Intermediate, Final> {
    private static final Logger LOG = LoggerFactory.getLogger(ResponseCookieHandler.class);
    private final URI uri;
    private final CookieManager manager;
    private final HttpResponseHandler<Intermediate, Final> delegate;

    ResponseCookieHandler(URI uri, CookieManager manager, HttpResponseHandler<Intermediate, Final> delegate) {
        this.uri = uri;
        this.manager = manager;
        this.delegate = delegate;
    }

    @Override
    public ClientResponse<Intermediate> handleResponse(HttpResponse httpResponse, HttpResponseHandler.TrafficCop trafficCop) {
        try {
            HttpHeaders headers = httpResponse.headers();
            this.manager.put(this.uri, Maps.asMap(headers.names(), headers::getAll));
            return this.delegate.handleResponse(httpResponse, trafficCop);
        }
        catch (IOException e) {
            LOG.error("Error while processing Cookies from header", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public ClientResponse<Intermediate> handleChunk(ClientResponse<Intermediate> clientResponse, HttpChunk httpChunk, long chunkNum) {
        return this.delegate.handleChunk(clientResponse, httpChunk, chunkNum);
    }

    @Override
    public ClientResponse<Final> done(ClientResponse<Intermediate> clientResponse) {
        return this.delegate.done(clientResponse);
    }

    @Override
    public void exceptionCaught(ClientResponse<Intermediate> clientResponse, Throwable throwable) {
        this.delegate.exceptionCaught(clientResponse, throwable);
    }
}

