/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.druid.io;

import java.io.IOException;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.druid.serde.DruidQueryRecordReader;
import org.apache.hadoop.hive.druid.serde.DruidSerDe;
import org.apache.hadoop.hive.druid.serde.DruidWritable;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.vector.VectorAssignRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatchCtx;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hive.druid.com.google.common.base.Preconditions;

public class DruidVectorizedWrapper<T extends Comparable<T>>
implements RecordReader<NullWritable, VectorizedRowBatch> {
    private final VectorAssignRow vectorAssignRow = new VectorAssignRow();
    private final DruidQueryRecordReader baseReader;
    private final VectorizedRowBatchCtx rbCtx;
    private final DruidSerDe serDe;
    private final Object[] rowBoat;
    private final int[] projectedColumns;
    private final DruidWritable druidWritable;

    public DruidVectorizedWrapper(DruidQueryRecordReader reader, Configuration jobConf) {
        this.rbCtx = Utilities.getVectorizedRowBatchCtx((Configuration)jobConf);
        if (this.rbCtx.getDataColumnNums() != null) {
            this.projectedColumns = this.rbCtx.getDataColumnNums();
        } else {
            this.projectedColumns = new int[this.rbCtx.getRowColumnTypeInfos().length];
            for (int i = 0; i < this.projectedColumns.length; ++i) {
                this.projectedColumns[i] = i;
            }
        }
        this.serDe = DruidVectorizedWrapper.createAndInitializeSerde(jobConf);
        this.baseReader = Preconditions.checkNotNull(reader);
        try {
            this.vectorAssignRow.init((StructObjectInspector)this.serDe.getObjectInspector());
        }
        catch (HiveException e) {
            throw new RuntimeException(e);
        }
        this.druidWritable = this.baseReader.createValue();
        this.rowBoat = new Object[this.rbCtx.getDataColumnCount()];
    }

    public boolean next(NullWritable nullWritable, VectorizedRowBatch vectorizedRowBatch) throws IOException {
        int rowsCount;
        vectorizedRowBatch.reset();
        for (rowsCount = 0; rowsCount < vectorizedRowBatch.getMaxSize() && this.baseReader.next(nullWritable, this.druidWritable); ++rowsCount) {
            if (this.projectedColumns.length <= 0) continue;
            try {
                this.serDe.deserializeAsPrimitive(this.druidWritable, this.rowBoat);
            }
            catch (SerDeException e) {
                throw new IOException(e);
            }
            for (int i : this.projectedColumns) {
                this.vectorAssignRow.assignRowColumn(vectorizedRowBatch, rowsCount, i, this.rowBoat[i]);
            }
        }
        vectorizedRowBatch.size = rowsCount;
        return rowsCount > 0;
    }

    public NullWritable createKey() {
        return NullWritable.get();
    }

    public VectorizedRowBatch createValue() {
        return this.rbCtx.createVectorizedRowBatch();
    }

    public long getPos() throws IOException {
        return this.baseReader.getPos();
    }

    public void close() throws IOException {
        this.baseReader.close();
    }

    public float getProgress() throws IOException {
        return this.baseReader.getProgress();
    }

    private static DruidSerDe createAndInitializeSerde(Configuration jobConf) {
        DruidSerDe serDe = new DruidSerDe();
        MapWork mapWork = Preconditions.checkNotNull(Utilities.getMapWork((Configuration)jobConf), "Map work is null");
        Properties properties = mapWork.getPartitionDescs().stream().map(partitionDesc -> partitionDesc.getTableDesc().getProperties()).findAny().orElseThrow(() -> new RuntimeException("Can not find table property at the map work"));
        try {
            serDe.initialize(jobConf, properties, null);
        }
        catch (SerDeException e) {
            throw new RuntimeException("Can not initialized the serde", e);
        }
        return serDe;
    }
}

