/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.druid.io;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.druid.DruidStorageHandler;
import org.apache.hadoop.hive.druid.DruidStorageHandlerUtils;
import org.apache.hadoop.hive.druid.io.DruidVectorizedWrapper;
import org.apache.hadoop.hive.druid.io.HiveDruidSplit;
import org.apache.hadoop.hive.druid.serde.DruidGroupByQueryRecordReader;
import org.apache.hadoop.hive.druid.serde.DruidQueryRecordReader;
import org.apache.hadoop.hive.druid.serde.DruidScanQueryRecordReader;
import org.apache.hadoop.hive.druid.serde.DruidTimeseriesQueryRecordReader;
import org.apache.hadoop.hive.druid.serde.DruidTopNQueryRecordReader;
import org.apache.hadoop.hive.druid.serde.DruidWritable;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedInputFormatInterface;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedSupport;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.util.StringUtils;
import org.apache.hive.druid.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.org.apache.druid.java.util.http.client.Request;
import org.apache.hive.druid.org.apache.druid.query.BaseQuery;
import org.apache.hive.druid.org.apache.druid.query.LocatedSegmentDescriptor;
import org.apache.hive.druid.org.apache.druid.query.Query;
import org.apache.hive.druid.org.apache.druid.query.SegmentDescriptor;
import org.apache.hive.druid.org.apache.druid.query.scan.ScanQuery;
import org.apache.hive.druid.org.apache.druid.query.scan.ScanResultValue;
import org.apache.hive.druid.org.apache.druid.query.spec.MultipleSpecificSegmentSpec;
import org.apache.hive.druid.org.jboss.netty.handler.codec.http.HttpMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DruidQueryBasedInputFormat
extends InputFormat<NullWritable, DruidWritable>
implements org.apache.hadoop.mapred.InputFormat<NullWritable, DruidWritable>,
VectorizedInputFormatInterface {
    private static final Logger LOG = LoggerFactory.getLogger(DruidQueryBasedInputFormat.class);

    public static DruidQueryRecordReader getDruidQueryReader(String druidQueryType) {
        switch (druidQueryType) {
            case "timeseries": {
                return new DruidTimeseriesQueryRecordReader();
            }
            case "topN": {
                return new DruidTopNQueryRecordReader();
            }
            case "groupBy": {
                return new DruidGroupByQueryRecordReader();
            }
            case "scan": {
                return new DruidScanQueryRecordReader();
            }
        }
        throw new IllegalStateException("Druid query type " + druidQueryType + " not recognized");
    }

    public InputSplit[] getSplits(JobConf job, int numSplits) throws IOException {
        return this.getInputSplits((Configuration)job);
    }

    public List<org.apache.hadoop.mapreduce.InputSplit> getSplits(JobContext context) throws IOException, InterruptedException {
        return Arrays.asList(this.getInputSplits(context.getConfiguration()));
    }

    protected HiveDruidSplit[] getInputSplits(Configuration conf) throws IOException {
        String druidQueryType;
        String address = HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_DRUID_BROKER_DEFAULT_ADDRESS);
        String queryId = HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_QUERY_ID);
        if (org.apache.commons.lang3.StringUtils.isEmpty(address)) {
            throw new IOException("Druid broker address not specified in configuration");
        }
        String druidQuery = StringEscapeUtils.unescapeJava(conf.get("druid.query.json"));
        if (org.apache.commons.lang3.StringUtils.isEmpty(druidQuery)) {
            LOG.warn("Druid query is empty; creating Select query");
            String dataSource = conf.get("druid.datasource");
            if (dataSource == null || dataSource.isEmpty()) {
                throw new IOException("Druid data source cannot be empty or null");
            }
            druidQuery = DruidStorageHandlerUtils.createScanAllQuery(dataSource, Utilities.getColumnNames((Configuration)conf));
            druidQueryType = "scan";
            conf.set("druid.query.type", druidQueryType);
        } else {
            druidQueryType = conf.get("druid.query.type");
            if (druidQueryType == null) {
                throw new IOException("Druid query type not recognized");
            }
        }
        if (queryId != null) {
            druidQuery = DruidQueryBasedInputFormat.withQueryId(druidQuery, queryId);
        }
        Job job = Job.getInstance((Configuration)conf);
        JobContext jobContext = ShimLoader.getHadoopShims().newJobContext(job);
        Path[] paths = FileInputFormat.getInputPaths((JobContext)jobContext);
        switch (druidQueryType) {
            case "timeseries": 
            case "topN": 
            case "groupBy": {
                return new HiveDruidSplit[]{new HiveDruidSplit(druidQuery, paths[0], new String[]{address})};
            }
            case "scan": {
                ScanQuery scanQuery = DruidStorageHandlerUtils.JSON_MAPPER.readValue(druidQuery, ScanQuery.class);
                return DruidQueryBasedInputFormat.distributeScanQuery(address, scanQuery, paths[0]);
            }
        }
        throw new IOException("Druid query type not recognized");
    }

    private static HiveDruidSplit[] distributeScanQuery(String address, ScanQuery query, Path dummyPath) throws IOException {
        boolean isFetch;
        boolean bl = isFetch = query.getScanRowsLimit() < Long.MAX_VALUE;
        if (isFetch) {
            return new HiveDruidSplit[]{new HiveDruidSplit(DruidStorageHandlerUtils.JSON_MAPPER.writeValueAsString(query), dummyPath, new String[]{address})};
        }
        List<LocatedSegmentDescriptor> segmentDescriptors = DruidQueryBasedInputFormat.fetchLocatedSegmentDescriptors(address, query);
        int numSplits = segmentDescriptors.size();
        HiveDruidSplit[] splits = new HiveDruidSplit[segmentDescriptors.size()];
        for (int i = 0; i < numSplits; ++i) {
            LocatedSegmentDescriptor locatedSD = segmentDescriptors.get(i);
            String[] hosts = new String[locatedSD.getLocations().size() + 1];
            for (int j = 0; j < locatedSD.getLocations().size(); ++j) {
                hosts[j] = locatedSD.getLocations().get(j).getHost();
            }
            hosts[locatedSD.getLocations().size()] = address;
            SegmentDescriptor newSD = new SegmentDescriptor(locatedSD.getInterval(), locatedSD.getVersion(), locatedSD.getPartitionNumber());
            Query<ScanResultValue> partialQuery = query.withQuerySegmentSpec(new MultipleSpecificSegmentSpec(Lists.newArrayList(newSD)));
            splits[i] = new HiveDruidSplit(DruidStorageHandlerUtils.JSON_MAPPER.writeValueAsString(partialQuery), dummyPath, hosts);
        }
        return splits;
    }

    private static List<LocatedSegmentDescriptor> fetchLocatedSegmentDescriptors(String address, BaseQuery query) throws IOException {
        List<LocatedSegmentDescriptor> segmentDescriptors;
        InputStream response;
        String intervals = org.apache.commons.lang3.StringUtils.join(query.getIntervals(), ",");
        String request = String.format("http://%s/druid/v2/datasources/%s/candidates?intervals=%s", address, query.getDataSource().getNames().get(0), URLEncoder.encode(intervals, "UTF-8"));
        LOG.debug("sending request {} to query for segments", (Object)request);
        try {
            response = DruidStorageHandlerUtils.submitRequest(DruidStorageHandler.getHttpClient(), new Request(HttpMethod.GET, new URL(request)));
        }
        catch (Exception e) {
            throw new IOException(StringUtils.stringifyException((Throwable)e));
        }
        try {
            segmentDescriptors = DruidStorageHandlerUtils.JSON_MAPPER.readValue(response, new TypeReference<List<LocatedSegmentDescriptor>>(){});
        }
        catch (Exception e) {
            response.close();
            throw new IOException(StringUtils.stringifyException((Throwable)e));
        }
        return segmentDescriptors;
    }

    private static String withQueryId(String druidQuery, String queryId) throws IOException {
        Query queryWithId = DruidStorageHandlerUtils.JSON_MAPPER.readValue(druidQuery, BaseQuery.class).withId(queryId);
        return DruidStorageHandlerUtils.JSON_MAPPER.writeValueAsString(queryWithId);
    }

    public org.apache.hadoop.mapred.RecordReader<NullWritable, DruidWritable> getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
        String druidQueryType = job.get("druid.query.type", "scan");
        DruidQueryRecordReader reader = DruidQueryBasedInputFormat.getDruidQueryReader(druidQueryType);
        reader.initialize((org.apache.hadoop.mapreduce.InputSplit)((HiveDruidSplit)split), (Configuration)job);
        if (Utilities.getIsVectorized((Configuration)job)) {
            return new DruidVectorizedWrapper(reader, (Configuration)job);
        }
        return reader;
    }

    public RecordReader<NullWritable, DruidWritable> createRecordReader(org.apache.hadoop.mapreduce.InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        String druidQueryType = context.getConfiguration().get("druid.query.type", "scan");
        return DruidQueryBasedInputFormat.getDruidQueryReader(druidQueryType);
    }

    public VectorizedSupport.Support[] getSupportedFeatures() {
        return new VectorizedSupport.Support[0];
    }
}

