/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.hbase;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapred.TableMapReduceUtil;
import org.apache.hadoop.hbase.mapreduce.TableInputFormatBase;
import org.apache.hadoop.hbase.mapreduce.TableSplit;
import org.apache.hadoop.hive.hbase.ColumnMappings;
import org.apache.hadoop.hive.hbase.HBaseSerDe;
import org.apache.hadoop.hive.hbase.HBaseSplit;
import org.apache.hadoop.hive.hbase.HiveHBaseInputFormatUtil;
import org.apache.hadoop.hive.hbase.ResultWritable;
import org.apache.hadoop.hive.ql.exec.SerializationUtilities;
import org.apache.hadoop.hive.ql.index.IndexPredicateAnalyzer;
import org.apache.hadoop.hive.ql.index.IndexSearchCondition;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Progressable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveHBaseTableInputFormat
extends TableInputFormatBase
implements InputFormat<ImmutableBytesWritable, ResultWritable> {
    static final Logger LOG = LoggerFactory.getLogger(HiveHBaseTableInputFormat.class);
    private static final Object HBASE_TABLE_MONITOR = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.apache.hadoop.mapred.RecordReader<ImmutableBytesWritable, ResultWritable> getRecordReader(InputSplit split, JobConf jobConf, Reporter reporter) throws IOException {
        RecordReader recordReader;
        Connection conn;
        HBaseSplit hbaseSplit = (HBaseSplit)split;
        TableSplit tableSplit = hbaseSplit.getTableSplit();
        Job job = new Job((Configuration)jobConf);
        TaskAttemptContext tac = ShimLoader.getHadoopShims().newTaskAttemptContext(job.getConfiguration(), (Progressable)reporter);
        Configuration hbaseConf = HBaseConfiguration.create((Configuration)jobConf);
        Scan scan = HiveHBaseInputFormatUtil.getScan(jobConf);
        LOG.debug("HBase configurations: {}", (Object)hbaseConf);
        LOG.info("Using global scan configuration (ignore per-split scan configs): {}", (Object)scan);
        Object object = HBASE_TABLE_MONITOR;
        synchronized (object) {
            conn = ConnectionFactory.createConnection((Configuration)hbaseConf);
            this.initializeTable(conn, tableSplit.getTable());
            this.setScan(scan);
            recordReader = this.createRecordReader((org.apache.hadoop.mapreduce.InputSplit)tableSplit, tac);
            try {
                recordReader.initialize((org.apache.hadoop.mapreduce.InputSplit)tableSplit, tac);
            }
            catch (InterruptedException e) {
                this.closeTable();
                conn.close();
                throw new IOException("Failed to initialize RecordReader", e);
            }
        }
        return new org.apache.hadoop.mapred.RecordReader<ImmutableBytesWritable, ResultWritable>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void close() throws IOException {
                Object object = HBASE_TABLE_MONITOR;
                synchronized (object) {
                    recordReader.close();
                    HiveHBaseTableInputFormat.this.closeTable();
                    conn.close();
                }
            }

            public ImmutableBytesWritable createKey() {
                return new ImmutableBytesWritable();
            }

            public ResultWritable createValue() {
                return new ResultWritable(new Result());
            }

            public long getPos() throws IOException {
                return 0L;
            }

            public float getProgress() throws IOException {
                float progress = 0.0f;
                try {
                    progress = recordReader.getProgress();
                }
                catch (InterruptedException e) {
                    throw new IOException(e);
                }
                return progress;
            }

            public boolean next(ImmutableBytesWritable rowKey, ResultWritable value) throws IOException {
                boolean next = false;
                try {
                    next = recordReader.nextKeyValue();
                    if (next) {
                        rowKey.set(((Result)recordReader.getCurrentValue()).getRow());
                        value.setResult((Result)recordReader.getCurrentValue());
                    }
                }
                catch (InterruptedException e) {
                    throw new IOException(e);
                }
                return next;
            }
        };
    }

    private Scan createFilterScan(JobConf jobConf, int iKey, int iTimestamp, boolean isKeyBinary) throws IOException {
        List<IndexSearchCondition> tsConditions;
        Map<String, List<IndexSearchCondition>> split;
        List<IndexSearchCondition> keyConditions;
        ArrayList<IndexSearchCondition> conditions;
        IndexPredicateAnalyzer analyzer;
        ExprNodeDesc residualPredicate;
        Scan scan = new Scan();
        String filterObjectSerialized = jobConf.get("hive.io.filter.object");
        if (filterObjectSerialized != null) {
            HiveHBaseInputFormatUtil.setupScanRange(scan, filterObjectSerialized, jobConf, false);
            return scan;
        }
        String filterExprSerialized = jobConf.get("hive.io.filter.expr.serialized");
        if (filterExprSerialized == null) {
            return scan;
        }
        ExprNodeGenericFuncDesc filterExpr = SerializationUtilities.deserializeExpression((String)filterExprSerialized);
        String keyColName = jobConf.get("columns").split(",")[iKey];
        ArrayList cols = TypeInfoUtils.getTypeInfosFromTypeString((String)jobConf.get("columns.types"));
        String colType = ((TypeInfo)cols.get(iKey)).getTypeName();
        boolean isKeyComparable = isKeyBinary || "string".equalsIgnoreCase(colType);
        String tsColName = null;
        if (iTimestamp >= 0) {
            tsColName = jobConf.get("columns").split(",")[iTimestamp];
        }
        if ((residualPredicate = (analyzer = HiveHBaseTableInputFormat.newIndexPredicateAnalyzer(keyColName, isKeyComparable, tsColName)).analyzePredicate((ExprNodeDesc)filterExpr, conditions = new ArrayList<IndexSearchCondition>())) != null) {
            LOG.debug("Ignoring residual predicate " + residualPredicate.getExprString());
        }
        if ((keyConditions = (split = HiveHBaseInputFormatUtil.decompose(conditions)).get(keyColName)) != null && !keyConditions.isEmpty()) {
            HiveHBaseInputFormatUtil.setupKeyRange(scan, keyConditions, isKeyBinary);
        }
        if ((tsConditions = split.get(tsColName)) != null && !tsConditions.isEmpty()) {
            HiveHBaseInputFormatUtil.setupTimeRange(scan, tsConditions);
        }
        return scan;
    }

    static IndexPredicateAnalyzer newIndexPredicateAnalyzer(String keyColumnName, boolean isKeyComparable, String timestampColumn) {
        IndexPredicateAnalyzer analyzer = new IndexPredicateAnalyzer();
        if (isKeyComparable) {
            analyzer.addComparisonOp(keyColumnName, new String[]{"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqual", "org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualOrGreaterThan", "org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualOrLessThan", "org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPLessThan", "org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPGreaterThan"});
        } else {
            analyzer.addComparisonOp(keyColumnName, new String[]{"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqual"});
        }
        if (timestampColumn != null) {
            analyzer.addComparisonOp(timestampColumn, new String[]{"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqual", "org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualOrGreaterThan", "org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualOrLessThan", "org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPLessThan", "org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPGreaterThan"});
        }
        return analyzer;
    }

    public InputSplit[] getSplits(final JobConf jobConf, final int numSplits) throws IOException {
        Object object = HBASE_TABLE_MONITOR;
        synchronized (object) {
            UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
            if (ugi == null) {
                return this.getSplitsInternal(jobConf, numSplits);
            }
            try {
                return (InputSplit[])ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<InputSplit[]>(){

                    @Override
                    public InputSplit[] run() throws IOException {
                        return HiveHBaseTableInputFormat.this.getSplitsInternal(jobConf, numSplits);
                    }
                });
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputSplit[] getSplitsInternal(JobConf jobConf, int numSplits) throws IOException {
        if (UserGroupInformation.getCurrentUser().hasKerberosCredentials()) {
            TableMapReduceUtil.initCredentials((JobConf)jobConf);
        }
        String hbaseTableName = jobConf.get("hbase.table.name");
        Connection conn = ConnectionFactory.createConnection((Configuration)HBaseConfiguration.create((Configuration)jobConf));
        TableName tableName = TableName.valueOf((String)hbaseTableName);
        this.initializeTable(conn, tableName);
        String hbaseColumnsMapping = jobConf.get("hbase.columns.mapping");
        boolean doColumnRegexMatching = jobConf.getBoolean("hbase.columns.mapping.regex.matching", true);
        try {
            if (hbaseColumnsMapping == null) {
                throw new IOException("hbase.columns.mapping required for HBase Table.");
            }
            ColumnMappings columnMappings = null;
            try {
                columnMappings = HBaseSerDe.parseColumnsMapping(hbaseColumnsMapping, doColumnRegexMatching);
            }
            catch (SerDeException e) {
                throw new IOException(e);
            }
            int iKey = columnMappings.getKeyIndex();
            int iTimestamp = columnMappings.getTimestampIndex();
            ColumnMappings.ColumnMapping keyMapping = columnMappings.getKeyMapping();
            Scan scan = this.createFilterScan(jobConf, iKey, iTimestamp, HiveHBaseInputFormatUtil.getStorageFormatOfKey(keyMapping.mappingSpec, jobConf.get("hbase.table.default.storage.type", "string")));
            ArrayList<String> addedFamilies = new ArrayList<String>();
            for (ColumnMappings.ColumnMapping colMap : columnMappings) {
                if (colMap.hbaseRowKey || colMap.hbaseTimestamp) continue;
                if (colMap.qualifierName == null) {
                    scan.addFamily(colMap.familyNameBytes);
                    addedFamilies.add(colMap.familyName);
                    continue;
                }
                if (addedFamilies.contains(colMap.familyName)) continue;
                scan.addColumn(colMap.familyNameBytes, colMap.qualifierNameBytes);
            }
            this.setScan(scan);
            Job job = new Job((Configuration)jobConf);
            JobContext jobContext = ShimLoader.getHadoopShims().newJobContext(job);
            Path[] tablePaths = FileInputFormat.getInputPaths((JobContext)jobContext);
            List splits = super.getSplits(jobContext);
            InputSplit[] results = new InputSplit[splits.size()];
            for (int i = 0; i < splits.size(); ++i) {
                results[i] = new HBaseSplit((TableSplit)splits.get(i), tablePaths[0]);
            }
            InputSplit[] inputSplitArray = results;
            return inputSplitArray;
        }
        finally {
            this.closeTable();
            conn.close();
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.closeTable();
        }
        finally {
            super.finalize();
        }
    }
}

